/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.server.LogStream;
import sun.rmi.transport.Transport;

public class RMIThread {
    private static ThreadGroup group;

    private RMIThread() {
    }

    public static Thread newThread(Runnable runnable, String string, boolean bl) {
        Thread thread = new Thread(RMIThread.getThreadGroup(), runnable, string);
        thread.setDaemon(bl);
        return thread;
    }

    private static synchronized ThreadGroup getThreadGroup() {
        if (group == null) {
            ThreadGroup threadGroup;
            ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
            while ((threadGroup = threadGroup2.getParent()) != null) {
                if (Transport.logLevel >= 20) {
                    LogStream.log("transport").println("RMIThread.getThreadGroup: searching up from ThreadGroup: " + threadGroup2);
                }
                threadGroup2 = threadGroup;
            }
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("RMIThread.getThreadGroup: found root ThreadGroup: " + threadGroup2);
            }
            try {
                group = new ThreadGroup(threadGroup2, "RMI runtime");
            }
            catch (SecurityException securityException) {
                if (Transport.logLevel >= 10) {
                    LogStream logStream = LogStream.log("transport");
                    logStream.println("RMIThread.getThreadGroup: security exception: ");
                    securityException.printStackTrace(logStream);
                }
                group = new ThreadGroup("RMI runtime (applet)");
            }
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("RMIThread.getThreadGroup: created RMI ThreadGroup:" + group);
            }
        }
        return group;
    }
}

