/*$Header: /a/lewis/disk/home/lfcs1/rjg/Ml/fam.src/UPTODATE/RCS/globdefs.h,v 4.0 89/09/20 13:32:55 rjg Exp $*/
/*$Log:	globdefs.h,v $
 * Revision 4.0  89/09/20  13:32:55  rjg
 * incorporated RCS
 * */

/* make sure NEGPTRS etc is defined if needed */
#include "system.h"

/*  Storage types  */

typedef unsigned char  Byte;
typedef unsigned short Word;
typedef unsigned long  LWord;
typedef signed short int   SWord;
typedef signed long int    SLWord;

/*   Global values   */

#ifdef NEGPTRS
#  define INTZERO   0x40000000
#  define Immed_(x) (signed_(x) >= 0)
#  define Ptr_(x)   (signed_(x) < 0)
#  define IPtrOff_(a,b) (LWord *)((int)(b)==0 ? (Byte *)(a) :  \
                                  ((Byte *)(a)) - (0x80000000 ^ (int)(b)))
#  define IPtrDiff_(a,b) (((Byte *)(a)) == ((Byte *)(b)) ? 0 :  \
                                  (((Byte *)(a)) - ((Byte *)(b))) ^ 0x80000000)
#else
#  define INTZERO    0xC0000000
#  define Immed_(x)  (signed_(x) <= 0)
#  define Ptr_(x)    (signed_(x) > 0)
#  define IPtrOff_(a,b) (LWord *)(((Byte *)(a)) - ((int)(b)))
#  define IPtrDiff_(a,b) PtrDiff_(a,b)
#endif

#define BigNum_(x) Ptr_(x)
#define INum_(x)   Immed_(x)
#define TRIV          0
#define NIL           0

#define fambool_(c)  ((c) ? TRUE_ : FALSE_)
#define cbool_(m)  ((m) & 1)
#define cint_(x)   (((LWord)(x)) - INTZERO)
#define famint_(x)  (((LWord)(x)) + INTZERO)
#define TRUE_ famint_(1)		/* The '_'s avoid clashes in XLib */
#define FALSE_ famint_(0)
#define cfile_(x) cint_(hd_(x))
#define cword_(x) (x)
#define cbyte_(x) (x)

#define ByteAdd_(a,b) (LWord *)(((Byte *)(a)) + ((int)(b)))
#define LWordAdd_(a,b)  (LWord *)(((LWord *)(a)) + ((int)(b)))
#define PtrDiff_(a,b) (((Byte *)(a)) - ((Byte *)(b)))
#define signed_(x) ((int) (x))

#define min(a,b) ((a) < (b) ? (a) : (b))

#define SaveRegs_     \
  FAM_AP = AP, FAM_CP = CP, FAM_TrapTop = TrapTop, FAM_PC = PC, FAM_FP = FP

#define RestoreRegs_  \
  AP = FAM_AP, CP = FAM_CP, TrapTop = FAM_TrapTop, PC = FAM_PC, FP = FAM_FP

#define SetTopProcess()  (CurrentProcess = CurrentState -> WaitingProcesses)

#define StackPointer(s)  (ByteAdd_((s), ((s) -> StkPos)))


