(* Directoires ne'cessaires a` la de'finition de ml_caml_latex_file *)
let source_directory = caml_directory^caml_version^"/src/" in
let lib_directory = caml_directory^caml_version^"/lib/" in
let manual_directory = caml_directory^caml_version^"/doc/manual/" in

(* Peut e'ventuellement e^tre en partie sous-traite' a`` make *)
let rec mk_caml_latex_file filename source_file tex_file =
if newest source_file tex_file = tex_file
   then comline("cp "^tex_file^" "^
                manual_directory^filename^source_ext^".tex")
   else ((try latex_caml_file (remove_source_ext source_file)
          with _ -> ((mv tex_file ("/tmp/"^filename^source_ext^".tex");
                      error_pn_message
                         ("erroneous "^filename^".ml.tex moved into /tmp"))
                      ?())
                    reraise);
         mk_caml_latex_file filename source_file tex_file) in

cd source_directory;
security (mk_caml_latex_file "NAME" "SOURCE") "TARGET";;



