/*******************************************************************

                 Les Fonctions Flottantes en C
                 utilisable sur tous les UNIX.

 *****************************************************************
   Ce fichier est en lecture seule hors du projet ALE de l'INRIA  
 Il est maintenu par : ILOG S.A. 9 rue Royale, 75008 Paris, France
 *****************************************************************


 *******************************************************************/

#include <signal.h>
#include <errno.h>
#include <math.h>

extern int errno;

/********************/
/*  Les Conversions */
/********************/

/* Conversions flottants <--> ascii */

/*
 * gcvt  - Floating output conversion to
 * minimal length string
 */

char	*ecvt();

char *
gcvt(number, ndigit, buf)
double number;
char *buf;
{
	int sign, decpt;
	register char *p1, *p2;
	register i;

	p1 = ecvt(number, ndigit, &decpt, &sign);
	p2 = buf;
	if (sign)
		*p2++ = '-';
	/* Exceptional numbers */
	if (*p1 == 'I') { /* Infinity */
		strcpy(p2, "Infinity");
		return buf;
	} else if (*p1 == 'N') { /* Not a Number */
		strcpy(p2, "NaN");
		return buf;
	}
	/* remove trailing 0 */
	for (i=ndigit-1; i>0 && p1[i]=='0'; i--)
		ndigit--;
	if (decpt >= 0 && decpt-ndigit > 4
	 || decpt < 0 && decpt < -3) { /* use E-style */
		decpt--;
		*p2++ = *p1++;
		*p2++ = '.';
		for (i=1; i<ndigit; i++)
			*p2++ = *p1++;
		*p2++ = 'e';
		if (decpt<0) {
			decpt = -decpt;
			*p2++ = '-';
		} else
			*p2++ = '+';
		if (decpt >= 100) {
			*p2++ = decpt/100 + '0';
			decpt -= (decpt/100)*100;
		}
		*p2++ = decpt/10 + '0';
		*p2++ = decpt%10 + '0';
	} else { /* use F-style */
		if (decpt<=0) {
			if (*p1!='0')
				*p2++ = '.';
			while (decpt<0) {
				decpt++;
				*p2++ = '0';
			}
		}
		for (i=1; i<=ndigit; i++) {
			*p2++ = *p1++;
			if (i==decpt)
				*p2++ = '.';
		}
		if (ndigit<decpt) {
			while (ndigit++<decpt)
				*p2++ = '0';
			*p2++ = '.';
		}
	}
	/* don't remove trailing .
	if (p2[-1]=='.')
		p2--; */
	*p2 = '\0';
	return(buf);
}


/* Conversion double flottant -> ascii */

int cvdtoa(double number,char *buffer) {
	char* depart;

	depart = gcvt(number, 12, buffer);
	while(*buffer != '\0')
	    buffer++;
	return(buffer - depart);
}

/* Conversion simple flottant ->  ascii */

int cvftoa(float number, char *buffer) {
	char* depart;

        depart = gcvt((double)number, 7, buffer);
	while(*buffer != '\0')
	    buffer++;
	return(buffer - depart);
}

extern double atof(char *);

/* Conversion ascii -> double flottant */

double cvatod (char *buffer) {
	double foo;

	errno = 0;
	foo = atof(buffer);
	if (errno == ERANGE)
		kill (getpid(), SIGFPE);
	return(foo);
}

/* Conversion ascii -> simple flottant */

float cvatof (char *buffer) {
	double foo;

	errno = 0;
	foo = atof(buffer);
	if (errno == ERANGE)
		kill (getpid(), SIGFPE);
	return((float)foo);
}

/* fpow (power simple precision) */

float fpow(float x, float y) {
    return (float)(pow((double)x , (double)y));
}
