;; Extracts yacc tables and actions form yacc output.
;;

(defvar beg)
(defvar Name (nth 3 command-line-args))
(defvar the-buffer (current-buffer))
(defvar work-buffer (generate-new-buffer "work"))

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents "y.tab.c")

(goto-char (point-min))
(search-forward "define yyclearin")
(forward-line 0)
(setq beg (point))
(re-search-forward "^# *line")
(forward-line 1)
(delete-region beg (point))

(goto-char (point-min))
(re-search-forward "^(\\* Caml part \\*)$" (point-max))
(forward-line 0)
(delete-region (point) (point-max))

(goto-char (point-min))
(replace-regexp
   "# *define *\\([0-9A-Za-z_]*\\)\\(.*\\)$"
   "let UnIqUe_NaMe_\\1 =\\2;;" nil)

(goto-char (point-min))
(insert "
directive open_env \""
Name
"\";;

(* BEGINNING OF LEXICALS *)

let syntax_name = \""
Name
"\";;
")

(set-buffer the-buffer)
(erase-buffer)
(insert-buffer work-buffer)

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents "y.tab.c")

(goto-char (point-min))
(search-forward "short yyexca")
(forward-line -1)
(delete-region (point-min) (point))

(goto-char (point-min))
(re-search-forward "# *ifndef *lint")
(forward-line 0)
(delete-region (point) (point-max))

(goto-char (point-min))
(replace-string "short" "let ")
(goto-char (point-min))
(replace-regexp "\\[\\].*" " = [|")
(goto-char (point-min))
(replace-string "," ";")
(goto-char (point-min))
(replace-regexp "\\(default_ol_grammar:=(\"[^;]*\\);\\(.*\\)" "\\1,\\2")
(goto-char (point-min))
(replace-string "};" "|];;")
(goto-char (point-min))
(replace-regexp "# *define *\\([A-Z]*\\)\\(.*\\)$" "let \\1 =\\2;;")

(goto-char (point-max))
(search-backward "let YYNPROD = ")
(forward-line -2)
(re-search-forward ";$")
(delete-backward-char 1)
(goto-char (point-min))
(insert "
(* BEGINNING OF TABLES *)
")

(goto-char (point-max))
(insert "
(* END OF TABLES *)
")

(set-buffer the-buffer)
(goto-char (point-max))
(insert-buffer work-buffer)

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents "y.tab.c")

(goto-char (point-min))
(search-forward "switch(yym)")
(forward-line 1)
(delete-region (point-min) (point))

(goto-char (point-min))
(re-search-forward "[ 	]goto ")
(forward-line -1)
(delete-region (point) (point-max))

(goto-char (point-min))
(replace-regexp
    "^case \\(.*\\):"
    "vect_assign(UnIqUe_NaMe_yyact_vect, \\1, (fun () -> ")
(goto-char (point-min))
(replace-regexp "^# line\\(.*\\)$" "(* action line\\1 *)")
(goto-char (point-min))
(replace-regexp "^{" "Repr (")
(goto-char (point-min))
(replace-string "} break;" ")));;")
(goto-char (point-min))
(replace-regexp "yypvt\\[-\\([0-9]*\\)\\]" "(peek_val \\1)")

(goto-char (point-min))
(insert "
let UnIqUe_NaMe_yytabs =
  Parse_table(yyexca,yyact,yypact,yypgo,yyr1,yyr2,yychk,yydef);;

(* BEGINNING OF ACTIONS *)

let UnIqUe_NaMe_yyact_vect = vector (YYNPROD+1) of (fun () -> !yy_val);;
")
(goto-char (point-max))
(insert "
let UnIqUe_NaMe_yyactions n = vect_item(UnIqUe_NaMe_yyact_vect, n) ();;

(* END OF ACTIONS *)

let UnIqUe_NaMe_lsyntax =
 Scan_syntax(UnIqUe_NaMe_strings,UnIqUe_NaMe_double,
	     (UnIqUe_NaMe_NUM,UnIqUe_NaMe_INT,UnIqUe_NaMe_FLOAT,
              UnIqUe_NaMe_IDENT,UnIqUe_NaMe_BOOL,UnIqUe_NaMe_STRING,
              UnIqUe_NaMe_INFIX),
	     (UnIqUe_NaMe_strdelim,UnIqUe_NaMe_cmndelim),
	     UnIqUe_NaMe_sub_syntaxes)
;;

let UnIqUe_NaMe_psyntax =
  Parse_syntax(UnIqUe_NaMe_yyactions,UnIqUe_NaMe_yytabs,YYLAST);;

let UnIqUe_NaMe_syntax =
  Syntax(\"UnIqUe_NaMe\",UnIqUe_NaMe_syntax_flag,
         UnIqUe_NaMe_lsyntax,UnIqUe_NaMe_psyntax);;
	
(* syntax_flag = (yy_)lex; syntax_type = syntax/value *)

add_syntax (make_parser UnIqUe_NaMe_syntax_type  UnIqUe_NaMe_syntax);()
")

(set-buffer the-buffer)
(goto-char (point-max))
(insert-buffer work-buffer)

(set-buffer work-buffer)
(erase-buffer)
(insert-file-contents "y.tab.c")

(print "4th phase")
(goto-char (point-min))
(re-search-forward "^(\\* Caml part \\*)$")
(forward-line -1)
(delete-region (point-min) (point))

(goto-char (point-min))
(search-forward "short yyexca")
(forward-line 0)
(delete-region (point) (point-max))

(set-buffer the-buffer)
(goto-char (point-max))
(insert-buffer work-buffer)
(goto-char (point-min))
(replace-string "UnIqUe_NaMe" Name)

(print "Saving...")
(write-region (point-min) (point-max) (concat Name "_mly.ml") nil 'nomsg)
(erase-buffer)
(kill-emacs)
