#standard arith true;;
#fast arith true;;

type peg = Out | Empty | Peg;;

let board =
        [|
          [| Out; Out; Out; Out; Out; Out; Out; Out; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Peg; Peg; Peg; Peg; Peg; Peg; Peg; Out|];
          [| Out; Peg; Peg; Peg; Empty; Peg; Peg; Peg; Out|];
          [| Out; Peg; Peg; Peg; Peg; Peg; Peg; Peg; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Out; Out; Peg; Peg; Peg; Out; Out; Out|];
          [| Out; Out; Out; Out; Out; Out; Out; Out; Out|]
        |]
;;

let moves = vector 31 of ([||] : int vect vect);;

let dir = [| [|0;1|]; [|1;0|]; [|0;-1|]; [|-1;0|] |];;

let counter = ref 0;;

exception found;;

let rec solve m =

  let i1 = ref 0
  and i2 = ref 0
  and j1 = ref 0
  and j2 = ref 0
  and d1 = ref 0
  and d2 = ref 0 in

  counter:=!counter + 1;
  if m == 31 then
   (if board.(4).(4) == Peg then true else false)
  else
   try
    (if !counter mod 500 == 0 then display_int !counter;
    for i=1 to 7 do
     for j=1 to 7 do
      if board.(i).(j)==Peg then
       (for k=0 to 3 do (
         d1:=dir.(k).(0);
         d2:=dir.(k).(1);
         i1:=i+!d1; i2:=!i1+!d1;
         j1:=j+!d2; j2:=!j1+!d2;
         if board.(!i1).(!j1)==Peg && board.(!i2).(!j2)==Empty then
           (board.(i).(j) <- Empty;
            board.(!i1).(!j1) <- Empty;
            board.(!i2).(!j2) <- Peg;
            if solve(m+1) then
               (moves.(m) <- [| [| i; j |]; [| !i2; !j2 |] |];raise found);
            board.(i).(j) <- Peg;
            board.(!i1).(!j1) <- Peg;
            board.(!i2).(!j2) <- Empty))
        done)
     done
    done;
    false)
   with found -> true
;;

let rec print_board board =
 display_newline();
 for i=0 to 8 do
  for j=0 to 8 do
    print_peg board.(i).(j)
  done;
  display_newline()
 done

and print_peg = function
    Out -> display_string "."
  | Empty -> display_string " "
  | Peg -> display_string "$"
;;


let init_board board =
 for i=0 to 8 do
  for j=0 to 8 do
    board.(i).(j) <- (
    when
       i=4  && j=4 -> Empty
     | i>=1 && i<=7 && j>=3 && j<=5 -> Peg
     | i>=3 && i<=5 && j>=1 && j<=7 -> Peg
     | _ -> Out)
  done
 done
;;

let main () =
    counter:=0;
    init_board board;
    modify_vect (fun _ -> [||]) moves;
    solve 0; print_board board;;

let print_solution () =
    let print_move mov =
     let i = mov.(0).(0)
     and j = mov.(0).(1)
     and k = mov.(1).(0)
     and l = mov.(1).(1) in
     display_string "Move peg ";display_int i;display_int j;
     display_string " to ";display_int k;display_int l;
     board.(i).(j) <- Empty;
     board.(k).(l) <- Peg;
     display_bool (i==k);
     display_int ((i+k) quo 2);
     (when i==k -> board.(i).((l+j) quo 2) <- Empty
         | _ -> board.((i+k) quo 2).(j) <- Empty);
     print_board board;
     display_newline()
    in
    init_board board;
    print_board board;
    for i = 0 to 30 do
    print_move (moves.(i))
    done
;;

(*
#solve 0;;
true : bool
Evaluation has needed: Runtime: 39.07s GC: 2.11s Conses: 0


#moves;;
[|[|[|2; 4|]; [|4; 4|]|]; [|[|3; 2|]; [|3; 4|]|];
  [|[|1; 3|]; [|3; 3|]|]; [|[|1; 5|]; [|1; 3|]|];
  [|[|3; 4|]; [|3; 2|]|]; [|[|3; 1|]; [|3; 3|]|];
  [|[|3; 5|]; [|1; 5|]|]; [|[|3; 7|]; [|3; 5|]|];
  [|[|4; 3|]; [|2; 3|]|]; [|[|1; 3|]; [|3; 3|]|];
  [|[|4; 1|]; [|4; 3|]|]; [|[|4; 3|]; [|2; 3|]|];
  [|[|4; 5|]; [|4; 3|]|]; [|[|4; 7|]; [|4; 5|]|];
  [|[|4; 5|]; [|2; 5|]|]; [|[|1; 5|]; [|3; 5|]|];
  [|[|5; 3|]; [|3; 3|]|]; [|[|2; 3|]; [|4; 3|]|];
  [|[|5; 1|]; [|5; 3|]|]; [|[|5; 4|]; [|5; 2|]|];
  [|[|6; 5|]; [|4; 5|]|]; [|[|5; 7|]; [|5; 5|]|];
  [|[|7; 3|]; [|5; 3|]|]; [|[|4; 3|]; [|6; 3|]|];
  [|[|7; 5|]; [|7; 3|]|]; [|[|7; 3|]; [|5; 3|]|];
  [|[|5; 2|]; [|5; 4|]|]; [|[|5; 4|]; [|5; 6|]|];
  [|[|3; 5|]; [|5; 5|]|]; [|[|5; 6|]; [|5; 4|]|]; [|[|6; 4|]; [|4; 4|]|]|] :
 int vect vect vect
Evaluation has needed: Runtime: 0.02s GC: 0.00s Conses: 0

#board;;
[|[|Out; Out; Out; Out; Out; Out; Out; Out; Out|];
  [|Out; Out; Out; Empty; Empty; Empty; Out; Out; Out|];
  [|Out; Out; Out; Empty; Empty; Empty; Out; Out; Out|];
  [|Out; Empty; Empty; Empty; Empty; Empty; Empty; Empty; Out|];
  [|Out; Empty; Empty; Empty; Peg; Empty; Empty; Empty; Out|];
  [|Out; Empty; Empty; Empty; Empty; Empty; Empty; Empty; Out|];
  [|Out; Out; Out; Empty; Empty; Empty; Out; Out; Out|];
  [|Out; Out; Out; Empty; Empty; Empty; Out; Out; Out|];
  [|Out; Out; Out; Out; Out; Out; Out; Out; Out|]|] :
 peg vect vect
Evaluation has needed: Runtime: 0.00s GC: 0.00s Conses: 0

let i = ref 0
and j = ref 0;;

let rec print_board board =
 loop i:=0 when !i <= 8 step incr i do
  loop j:=0 when !j <= 8 step incr j do
    print_peg board.(!i).(!j)
  done;
  display_newline()
 done

and print_peg = function
    Out -> display_string "."
  | Empty -> display_string " "
  | Peg -> display_string "$"
;;

let move board
.........
...   ...
...   ...
.       .
.   $   .
.       .
...   ...
...   ...
.........
*)
