; .EnTete "Le-Lisp (c) version 15.2" " " "La bibliothe`que des dates"
; .EnPied " " "%" " "
; .SuperTitre "Les bibliothe`ques des Dates"
;
; .Centre "*****************************************************************"
; .Centre " Ce fichier est en lecture seule hors du projet ALE de l'INRIA.  "
; .Centre " Il est maintenu par ILOG SA, 2 Avenue Gallie'ni, 94250 Gentilly "
; .Centre " (c) Le-Lisp est une marque de'pose'e de l'INRIA                 "
; .Centre "*****************************************************************"

; .Centre "$Header: libdate.ll,v 6.1 90/03/08 16:43:10 kuczynsk Rel $"

(unless (>= (version) 15.2)
        (error 'load 'erricf 'date))

(defvar #:sys-package:colon 'date)

; .Section "Documentation"

; 
;         L E S  D A T E S  (extension du module "date")
; 

; Rajouts :
;  - comparaisons de dates.
;  - affichage au format long.
;  - calcul du nombre de jours.

; (eqdate <date1> <date2>) -> comparaison de dates.
; (<date <date1> <date2>)
; ...
; 
; (date-to-number <date>) -> nombre de jours depuis le 1 janvier 0 a 0 heure.
; 
; (number-to-date <n>) -> transformation inverse.
; 
; (date-of-file <path>) -> ramene la date d'un fichier
;
; #:date:date-min  ->  la date du de'but du monde


(unless (featurep 'date)
	(loadmodule 'date))

; .Section "Les donne'es"
; 
; De'but de la partie de'pendante du site
; A chaque fois, on a les versions courtes et longues


; Les noms des mois

; Les noms des mois
(defmessage :ljanv (french "janvier")
                  (english "january"))
(defmessage :lfevr (french "fevrier")
                  (english "february"))
(defmessage :lmars (french "mars")
                  (english "march"))
(defmessage :lavr (french "avril")
                  (english "april"))
(defmessage :lmai (french "mai")
                  (english "may"))
(defmessage :ljuin (french "juin")
                  (english "june"))
(defmessage :ljuil (french "juillet")
                  (english "july"))
(defmessage :laout (french "aout")
                  (english "august"))
(defmessage :lsept (french "septembre")
                  (english "september"))
(defmessage :loct (french "octobre")
                  (english "october"))
(defmessage :lnov (french "novembre")
                  (english "november"))
(defmessage :ldec (french "decembre")
                  (english "december"))

(defvar long-month-names '((1 . :ljanv)(2 . :lfevr)(3 . :lmars)
    (4 . :lavr)(5 . :lmai)(6 . :ljuin)(7 . :ljuil)(8 . :laout)
    (9 . :lsept)(10 . :loct)(11 . :lnov)(12 . :ldec)))


; Les noms des jours
(defmessage :llun (french "lundi")
                 (english "monday"))
(defmessage :lmar (french "mardi")
                 (english "tuesday"))
(defmessage :lmer (french "mercredi")
                 (english "wednesday"))
(defmessage :ljeu (french "jeudi")
                 (english "thursday"))
(defmessage :lven (french "vendredi")
                 (english "friday"))
(defmessage :lsam (french "samedi")
                 (english "saturday"))
(defmessage :ldim (french "dimanche")
                 (english "sunday"))

(defvar long-day-names '((1 . :llun)(2 . :lmar)(3 . :lmer)(4 . :ljeu)
    (5 . :lven)(6 . :lsam)(7 . :ldim)))

; Fin des donne'es de'pendantes du site


; .Section "Les conversions"

; Le format long (48 caracteres)

(de long-string-date (date)
    (ifn (datep date) (error 'long-string-date 'errbpa date))
    (let ((year (:year date))
          (month-name (get-message (cassq (:month date) long-month-names)))
          (day (:day date))(hour (:hour date))
          (min (:minute date))(sec (:second date))
          (msec (:msecond date))
          (day-name (get-message (cassq (:week-day date) long-day-names)))
          (result (makestring 48 #\sp)))
        (bltstring result (- 3 (div (slength day-name) 3)) day-name 0)
        (bltstring result (- 12 (slength day)) day 0)
        (bltstring result (- 16 (div (slength month-name) 3)) month-name 0)
        (bltstring result (- 27 (slength year)) year 0)
        (bltstring result 30 "00h 00mn 00s 000ms" 0)
        (bltstring result (- 32 (slength hour)) hour 0)
        (bltstring result (- 36 (slength min)) min 0)
        (bltstring result (- 41 (slength sec)) sec 0)
        (bltstring result (- 46 (slength msec)) msec 0)
        result))

; Un test : Le premier jour (a` Rome) du calendrier gre'gorien
; (eq (week-day-number #[1582 10 15 () () ()]) 5)

; .Section "Les comparaisons"

; L'e'galite' des dates (avec le controle)

(de eqdate (date1 date2)
    (and (datep date1) (datep date2) (eqvector date1 date2)))

(synonymq =date eqdate)

(de /=date (date1 date2) (not (eqdate date1 date2)))

(synonymq <>date /=date)

; La comparaison des dates

(de <?date (date1 date2 equal?)
    (ifn (datep date1) (error '<date 'errbpa date1))
    (ifn (datep date2) (error '<date 'errbpa date2))
    (tag date-cmp
         (for (i 0 1 6)
             (cond
                ((< (or (vref date1 i) 0)
		    (or (vref date2 i) 0))
		 (exit date-cmp t))
                ((> (or (vref date1 i) 0)
		    (or (vref date2 i) 0))  (exit date-cmp ()))))
         equal?))

(de <date (date1 date2) (<?date date1 date2 ()))
(de <=date (date1 date2) (<?date date1 date2 t))
(de >date (date1 date2) (<?date date2 date1 ()))
(de >=date (date1 date2) (<?date date2 date1 t))

; .Section "L'arithme'tique"

; necessite les rationnels pour etre exact !
 
(defvar tropic-year-length 36524220/100000)        ; 365.24220
(defvar gregorian-year-length 36524250/100000)        ; 365.24250
(defvar tropic-month-length (/ tropic-year-length 12))
(defvar moon-month-length 29530588/1000000)        ; 29.530588

; transformation format date -> jours (depuis 1 janvier 0 0h00:00.000)

(de date-to-number (date)
   (ifn (datep date) (error 'date-to-number 'errbpa date))
   (let ((year (:year date))(month (:month date))
         (day (:day date))(hour (:hour date))
         (min (:minute date))(sec (:second date))
         (msec (or (:msecond date) 0)))
        (+ (* 365 year)
           (leap-number year)
           (year-day-number date)
           (* hour 1/24)
           (* min 1/1440)
           (* sec 1/86400)
           (* msec 1/86400000)
	   -1
	   )))

; transformation jours -> date (0 -> 1 janvier 0 0h00:00.000)

(de number-to-date (n)
    (let ((date (makevector 8 0)))
        (typevector date 'date)
        (let ((year (fix (/ n tropic-year-length))))
            (:year date year)
            (setq n (- n (* year 365) (leap-number year))))
        (adjust-year)
        (let ((month (1+ (fix (/ n tropic-month-length)))))
            (:month date month)
            (setq n (- n (year-day-number date))))
        (let ((day (1+ (fix n))))
            (:day date day)
            (setq n (1+ (- n day))))
        (adjust-day)
        (:week-day date (week-day-number date))
        (let ((hour (fix (* 24 n))))
            (:hour date hour)
            (setq n (- n (* hour 1/24))))
        (let ((min (fix (* 1440 n))))
            (:minute date min)
            (setq n (- n (* min 1/1440))))
        (let ((sec (fix (* 86400 n))))
            (:second date sec)
            (setq n (- n (* sec 1/86400))))
        (let ((msec (fix (* 86400000 n))))
            (:msecond date msec)
            (setq n (- n (* msec 1/86400000))))
        date))

(de adjust-year ()
;    (print "ay" date n)
    (cond
        ((< n 0)
         (:year date (1- (:year date)))
         (setq n (+ n (if (leap-year-p (:year date)) 366 365)))
         (adjust-year))
        ((or (>= n 367) (and (>= n 366) (not (leap-year-p (:year date)))))
         (setq n (- n (if (leap-year-p (:year date)) 366 365)))
         (:year date (1+ (:year date)))
         (adjust-year))))

(de adjust-day ()
;    (print "ad" date n)
    (cond
        ((< n 0)
         (let ((adjust (1+ (fix (abs n)))))
            (:day date (- (:day date) adjust))
            (setq n (+ n adjust))))
        ((>= n 1)
         (let ((adjust (fix n)))
            (:day date (+ (:day date) adjust))
            (setq n (- n adjust)))))
    (adjust-month))

(de adjust-month ()
;    (print "am" date n)
    (cond
        ((< (:day date) 1)
         (:month date (prev-month (:month date)))
         (:day date
            (+ (:day date) (month-length (:month date) (:year date))))
         (adjust-month))
        ((> (:day date) (month-length (:month date) (:year date)))
         (:day date
            (- (:day date) (month-length (:month date) (:year date))))
         (:month date (next-month (:month date)))
         (adjust-month))))

(defun prev-month (m)
  (if (eqn m 1) 12 (sub1 m)))

(defun next-month (m)
  (if (eqn m 12) 1 (add1 m)))

; .Section "les utilitaires"
; La date d'un fichier

(unless (featurep 'callext)
	(loadmodule 'callext))

(defextern _getfdate (fixvector string))

(defun date-of-file (path)
  (unless (or (pathnamep path)
	      (stringp path))
	  (error 'date-of-file 'ERRPATHNOTPATH path))
  (unless (probefile path)
	  (error 'date-of-file 'errfile path))
  (let ((d (create-date)))
    (_getfdate d (coerce-namestring path))
    d))

(unless (boundp '#:date:date-min)
	(defvar #:date:date-min (create-date))
	(#:date:year #:date:date-min 0)
	(#:date:month #:date:date-min 0)
	(#:date:day #:date:date-min 0)
	(#:date:hour #:date:date-min 0)
	(#:date:minute #:date:date-min 0)
	(#:date:second #:date:date-min 0))

