(* $Id: makep.ml,v 8.1 91/06/20 14:41:50 ddr Exp $
 *
 * Make function
 *
 * $Log:	makep.ml,v $
 * Revision 8.1  91/06/20  14:41:50  ddr
 * - distrib
 * 
 * Revision 7.1  91/05/28  20:51:46  ddr
 * - distrib
 * 
 * Revision 6.3  91/05/28  20:32:13  ddr
 * - correction bug
 * 
 * Revision 6.2  91/05/25  19:16:39  ddr
 * - type file -> type target
 * - ne relit pas makefile.ml
 * 
 * Revision 6.1  91/04/22  14:52:16  ddr
 * - distrib
 *)

module makep using
  value fdate : string -> num;
  type target =
    'Source of string * string | 'Object of string * string
  | 'Core of string | 'Phony of string | 'File of string * string;
  exception dont_know;
  value make_gram : string -> Parsers;
  value make_handler : (target -> bool) -> (target -> unit);
;

#standard arith false;;
#fast arith false;;

let doit = ref false
;;

let make_actions =
  do_list (fun c ->
    display_string ("--- " ^ c); display_newline();
    if !doit then eval_string c;
    ()
  )
;;

let last_wd = ref "";;
let last_makefile_date = ref 0;;
let last_makef = ref (fun (_ : target) -> false);;

let make_doit target =
  let wd = pwd()
  and makefile_date = fdate (abs_path"makefile.ml") in
  if wd <> !last_wd or makefile_date <> !last_makefile_date then (
    message "<W> reading makefile.ml";
    let fc = open_in "makefile.ml" in
    let k = (try
      match (make_gram "make").Parse_channel fc with
        MLquote(dynamic(m : ML)) -> m
      | _ -> raise dont_know
    with reraise -> close_in fc; raise reraise) in
    close_in fc;
    (match eval_syntax k with
      dynamic(f: target -> bool) -> last_makef := f
    | _ -> raise dont_know);
    last_wd := wd;
    last_makefile_date := makefile_date
  );
  make_handler !last_makef target
;;

let make target = doit := true; make_doit target
and maken target = doit := false; make_doit target
;;

end module with
  value make;
  value maken;
  value make_actions;
  value doit;
;
