(* $Id: ddr_ext.ml,v 8.1 91/06/20 14:46:13 ddr Exp $
 *
 * $Log:	time.ml,v $
 * Revision 8.1  91/06/20  14:46:13  ddr
 * - distrib
 * 
 * Revision 7.1  91/05/28  20:51:18  ddr
 * - distrib
 * 
 * Revision 6.2  91/05/27  11:01:24  ddr
 * - sockets
 * 
 * Revision 6.1  91/04/22  14:48:48  ddr
 * - distrib
 *)

#standard arith false;;
#fast arith false;;

external_address_cache true;;

type C_Void = C_Void of unit;;
type C_Long = C_Long of address;;
type C_Short = C_Short of address;;
type C_Char = C_Char of int;;
type C_Int = C_Int of address;;

let void = C_Void();;

let num_of_addr_short x =
   if x == monster_int
   then 32768
   else if lt (x, #0)
   then 65536 + Int x
   else Int x
;;

let unsigned_num_of_address =
  function Addr_short x -> num_of_addr_short x
      |    Addr_long (x, y) -> 65536 * (num_of_addr_short x)
                               + num_of_addr_short y
;;

let num_of_address adr =
  let v = unsigned_num_of_address adr in
  if v < 2147483648 then v else v-4294967296
;;

(* for x < 65536 only *)
let int_short_of_num x =
  if x < 32768
  then int_of_num(x)
  else if x > 32768 && x < 65536
  then int_of_num(x - 65536)
  else if x = 32768
  then monster_int
  else failwith "int_short_of_num"
;;
  

let address_of_num nm =
  let n = (if (nm < 0) then (nm + 4294967296) else nm) in
  if (n < 32767) then Addr_short(int_of_num(n))
  else
    Addr_long(int_short_of_num(n quo 65536), int_short_of_num(n mod 65536))
;;
(*
let C_Int_of_Long = function C_Long(adr) -> C_Int(adr);;
*)
let C_Int_of_num n = C_Int(address_of_num(n));;
let C_Long_of_num n = C_Long(address_of_num(n));;
let C_Short_of_num n = C_Short(address_of_num(n));;
let num_of_C_Long = function C_Long(adr) -> num_of_address(adr);;
let num_of_C_Int = function C_Int(adr) -> num_of_address(adr);;
let num_of_C_Short = function C_Short(adr) -> num_of_address(adr);;
let Atom_of_num n = C_Long(address_of_num(n));;
let CINT = C_Int_of_num;;
let CLONG = C_Long_of_num;;
let CSHORT = C_Short_of_num;;


let Int_Add = function
	(C_Int(l1), C_Int(l2))
	-> C_Int_of_num(num_of_address(l1) + num_of_address(l2))
;;
(*
let Long_Add = function
	(C_Long(l1), C_Long(l2))
	-> C_Long_of_num(num_of_address(l1) + num_of_address(l2))
;;
*)
let Long_OR (l1, l2) =
    let rec lor_aux = function
	(n1, 0)		-> n1
|	(0, n1)		-> n1
|	(n1, n2) ->
	if ((n1 mod 2) + (n2 mod 2) > 0) then
	    1 + (2 * lor_aux (n1 quo 2, n2 quo 2))
	else
	    2 * lor_aux (n1 quo 2, n2 quo 2)
    in

    C_Long_of_num(lor_aux (num_of_C_Long l1, num_of_C_Long l2))
;;
(*
let Long_AND (l1, l2) =
    let rec land_aux = function
	(n1, 0)		-> n1
|	(0, n1)		-> n1
|	(n1, n2) ->
	if ((n1 mod 2) + (n2 mod 2) = 2) then
	    1 + (2 * land_aux (n1 quo 2, n2 quo 2))
	else
	    2 * land_aux (n1 quo 2, n2 quo 2)
    in

    C_Long_of_num(land_aux (num_of_C_Long l1, num_of_C_Long l2))
;;

let Long_XOR (l1, l2) =
    let rec lxor_aux = function
	(n1, 0)		-> n1
|	(0, n1)		-> n1
|	(n1, n2) ->
	if ((n1 mod 2) + (n2 mod 2) = 1) then
	    1 + (2 * lxor_aux (n1 quo 2, n2 quo 2))
	else
	    2 * lxor_aux (n1 quo 2, n2 quo 2)
    in

    C_Long_of_num(lxor_aux (num_of_C_Long l1, num_of_C_Long l2))
;;

*)
let Zero_Long = C_Long(address_of_num(0))
and One_Long  = C_Long(address_of_num(1))
and Zero_Int = C_Int(address_of_num(0))
and One_Int  = C_Int(address_of_num(1))
;;

let Bit_In_Long n =
  let x = ref 1 and 
      i = ref n in
    while decr(i) >= 0 do
	x := !x * 2
    done;
    C_Long(address_of_num(!x))
;;

let Bit_In_Int n =
  let x = ref 1 and 
      i = ref n in
    while decr(i) >= 0 do
	x := !x * 2
    done;
    C_Int(address_of_num(!x))
;;

#directive define_external_function(
  "ctime", <:Caml:Type<C_Void -> C_Long>>, "_ML_ctime"
);;
#directive define_external_function(
  "ctime_ms", <:Caml:Type<C_Void -> C_Short>>, "_ML_ctime_ms"
);;
#directive define_external_function(
  "fdate", <:Caml:Type<string -> C_Long>>, "_ML_fdate"
);;

type timeb = {
  time      : num;
  millitm   : num
}
;;

let ftime() =
  let t = ctime void in {
    time = num_of_C_Long t;
    millitm = num_of_C_Short(ctime_ms void)
  }
and fdate = B num_of_C_Long fdate;;

external_address_cache false;;
