(* Fonctions de Tracage de Courbes  *)
(* La courbe correspondant a une fonction est tracee   *)
(* dans le repere orthonorme unite' puis mise en place *)
(* au milieu de la page postscript par changement      *)
(* d'echelle et translation                            *)


(* CONSTANTES *)

(* bordure minimum autour des axes exprimee en proportion *)
(* de la moyenne entre hauteur et largeur de la courbe    *)
let visi_axes = 0.10;;          
(* depassement des axes par rapport aux limites de la courbe *)
let depassement_axes = 1.2;;

(* dimensions de la page postcript utile   *)
let page_width = 420 ;;
let page_height = 700;;
let hmargin = 25;;
let vmargin = 25;;
let page_center = (page_width/2,page_height/2);;

(* parametres de style *)
let (lsty:linestyle) = (3,roundcap,roundjoin,[]);;


(* FONCTIONS UTILITAIRES  *)

let scale n (x,y) = (n*x,n*y);;
let scale2 (n1,n2) (x,y) = (n1*x,n2*y);;
let mktrans (x1,y1) (x2,y2) = (x2-x1,y2-y1);;

let rec intervalle m n step =
 if  m>n then []
         else m :: intervalle (m+step) n step;;

let compute_unit e =
            if e >0.2 & e <=2 then 0.1
            if e > 2 & e < 10 then 1
            if e >= 10 & e <= 50 then 5
            if e >50 & e <= 100 then 10
            else failwith "unite "^(string_of_num e);;

let unit_points unit (x1,x2,y1,y2) =
 let l1 = map (fun x -> -x) (intervalle unit (-x1) unit)
          @ (intervalle unit x2 unit)
 and l2 = map (fun x -> -x) (intervalle unit (-y1) unit)
          @ (intervalle unit y2 unit)

in make_sketch
  (( map (fun x->seg[{xc=x;yc=unit/20};{xc=x;yc=-unit/10}]) l1)
  @( map (fun y->seg[{xc=unit/20;yc=y};{xc=-unit/10;yc=y}]) l2))
;;

let repere {xmin=a;xmax=b;ymin=c;ymax=d} =
 let p = make_sketch  [seg [{xc=a;yc=0};{xc=b;yc=0}];
                       seg [{xc=0;yc=c};{xc=0;yc=d}] ]

 and w = ((b-a)+(d-c))/30
 and e = min (b-a) (d-c)

in 
 let unit = compute_unit e
in
 let p1 = unit_points  unit (a,b,c,d)

in  (make_picture (((b-a)/1000,roundcap,roundjoin,[]),gra 0)) p
    JPICT
    (make_picture(((b-a)/1000,roundcap,roundjoin,[]),gra 0)) p1
;;


let curve(f,a,b,step) =
 let l1 = intervalle a b step
 in
  let l2 = map (fun x ->  {xc=x;yc=f x}) l1
  in
         make_sketch  [seg l2]  ;;

let curves(fl,a,b,step) =
   join_sketches ( map (fun f -> curve(f,a,b,step)) fl);;

let extend_frame  {xmin=a;xmax=b;ymin=c;ymax=d} =
  {xmin=depassement_axes *( min (-(b-a)*visi_axes) a);
   xmax=depassement_axes *( max b ((b-a)*visi_axes));
   ymin=depassement_axes*( min (-(d-c)*visi_axes) c);
   ymax=depassement_axes*( max d ((d-c)*visi_axes))};;


let set_in_axes (sketch:sketch) =
    let ({xmin=a;xmax=b;ymin=c;ymax=d} as f) 
          = extend_frame sketch.frame
    in
       let w = ((b-a)+(d-c))/30
       in
       let frame_style  = ((b-a)/100,roundcap,roundjoin,[])
       and frame_color = gra 0.5

    in let pict1 =    make_picture
                     (((b-a)/500,roundcap,roundjoin,[]) ,gra 0)
                     sketch
       and pict2 = repere f
       and pict3 =  
           make_picture (frame_style,frame_color)
                        (frame_sketch f)

       in  pict1 JPICT pict2 JPICT pict3;;


      
(* Construction d'une courbe au centre de l'ecran   *)

let center_picture ({pict=pict; 
                    frame = {xmin=a;xmax=b;ymin=c;ymax=d}} 
                   as p) =

   let width = b-a  
   and height= d-c
   and center = ((b-a)/2,(d-c)/2)  (* centre apres la translation *)
  
   in
      let scale_factor =  min (page_width/width) 
                               (page_height/height)
      in

         let T2 = translation 
              (mktrans (scale scale_factor center) page_center)
         and S = scaling (scale_factor,scale_factor) 
         and T1 = translation (-a,-c)
         and T3 = translation (hmargin,vmargin)

        in transform_picture
             (T3 CT T2 CT S CT T1)
             p;;


let centered_curve =
     center_picture o  set_in_axes o curve;;

let centered_curves =
     center_picture o  set_in_axes o curves;;
      

let draw_curve = display_picture o centered_curve;;

let draw_curves = display_picture o centered_curves;;


   


