load "escher_basic_pictures";;
echo_values false;;

let O={xc=0.0;yc=0.0};;

let a = make_text_picture  "A" {Name="Helvetica";Size=12.0} (Gra 0.0);;
let b = make_text_picture  "B" {Name="Helvetica";Size=12.0} (Gra 0.0);;
let c = make_text_picture  "C" {Name="Helvetica";Size=12.0} (Gra 0.0);;
let d = make_text_picture  "D" {Name="Helvetica";Size=12.0} (Gra 0.0);;

let FR = {xmin=0.0;ymin=-2.0;xmax=20.0;ymax=18.0};;

let [A;B;C;D] = map (force_picture_in_frame FR)   [a;b;c;d];;

let B2 = extend_picture_frame Horiz_ext 0.5 B;;
let C2 = extend_picture_frame Vertic_ext 0.5 C;;
let C4 = extend_picture_frame All_ext 0.5 C;;
let D4 = extend_picture_frame All_ext 0.5 D;;


let rot = rotate_picture 90.0;;
let small = scale_picture (0.5,0.5);;

let trio(p1,p2,p3) =
   (p1 BPICT p2) OPICT p3;;

let quartet (p1,p2,p3,p4) =
    (p1 BPICT p2) OPICT (p3 BPICT p4);;


let cycle p =
    (p BPICT (rot (rot (rot p)))) 
    OPICT 
    ((rot p) BPICT (rot(rot p)));;

let lsty= {linewidth=0.5;linecap=Squarecap;
           linejoin=Miterjoin;dashpattern=[]};;

let trio_ex =
  let aftp = add_frame_to_picture (lsty,Gra 0.0)
  in trio(aftp A,aftp B,aftp C4);;

let quartet_ex = 
  let aftp = add_frame_to_picture (lsty,Gra 0.0)
  in quartet(aftp A,aftp B2,aftp C2,aftp D4);;

let lsty= {linewidth=0.25;linecap=Squarecap;
           linejoin=Miterjoin;dashpattern=[]};;

let cycle_ex =
  let aftp = add_frame_to_picture (lsty,Gra 0.0)
  in scale_picture (1.5,1.5) (cycle(aftp A));;

(* Il faut des fonctions BPICT' et OPICT' qui fassent un scaling
   vertical ou horizontal du frame sans modifier la picture   *)
(* de facon notamment a mettre des captions sous les pictures   *)


let TRIO =
  (scale_picture (3.0,3.0) trio_ex) 
  OPICT' 
  (make_text_picture  "trio(A,B,C)" {Name="Helvetica";Size=12.0} (Gra 0.0));;

let QUARTET =
  (scale_picture (3.0,3.0)  quartet_ex)
  OPICT' 
  (make_text_picture  "quartet(A,B,C,D)" {Name="Helvetica";Size= 12.0} (Gra 0.0));;

let CYCLE =
  (scale_picture (3.0,3.0) cycle_ex)
  OPICT' 
  (make_text_picture  "cycle(A)" {Name="Helvetica";Size= 12.0} (Gra 0.0) );;



let FIG2 =

  (extend_picture_frame Right_ext 0.2 TRIO)
  BPICT
  (extend_picture_frame Horiz_ext 0.2 QUARTET)
  BPICT
  (extend_picture_frame Left_ext 0.2 CYCLE);;


let lsty = {linewidth=0.01;
            linecap=Roundcap;
            linejoin=Roundjoin;
            dashpattern=[]};;



let [P;Q;R;S] = map (hflip_picture o (make_draw_picture) (lsty,Gra 0.0))
                    [skp;skq;skr;sks];;

(* Explicitation of all the construction steps *)

let T =quartet(P,Q,R,S);;

let U = cycle (rot Q);;

let C0=U and L0 = rot T and T0=T;;

let C1= quartet(small C0,small(L0 BPICT T0)
               ,small((rot T0)OPICT(rot L0)), U)
and L1 = trio(small L0,small T0,rot T)
and T1 = trio(small L0,small T0, T);;

let C2= quartet(small C1,small (L1 BPICT T1)
               ,small((rot T1)OPICT(rot L1)), U)
and L2 = trio(small L1,small T1,rot T)
and T2 = trio(small L1,small T1, T);;

let corner= quartet(small C2,small L2,
                    small(rot T2),rot Q);;

let SL = cycle corner;;


(*   The recursive definition    *)


let square_limit n (P,Q,R,S) =
   let TT=quartet(P,Q,R,S)
   and UU=cycle (rot Q)
     in
let normal_step(C,L,T) =
    (quartet(small C,small(L BPICT T),small((rot T)OPICT(rot L)), UU)
    ,trio(small L,small T,rot TT)
    ,trio(small L,small T, TT))

and final_step(C,L,T) = quartet(small C,small L, small(rot T),rot Q)
in

  cycle(final_step(iterate normal_step n (T,rot T,U)));;


let [P';Q';R';S'] = map 
                    ((scale_picture (100.0,100.0))
                      o
                    (extend_picture_frame All_ext 0.1))
                    [P;Q;R;S];;


let P'' = P' OPICT' (make_text_picture  "Picture A" {Name="Helvetica";Size=12.0} (Gra 0.0));;
let Q'' = Q' OPICT' (make_text_picture  "Picture B" {Name="Helvetica";Size=12.0} (Gra 0.0));;
let R'' = R' OPICT' (make_text_picture  "Picture C" {Name="Helvetica";Size=12.0} (Gra 0.0));;
let S'' = S' OPICT' (make_text_picture  "Picture D" {Name="Helvetica";Size=12.0} (Gra 0.0));;

let FIG1 =
 (extend_picture_frame Bottom_ext 0.1
    ((((extend_picture_frame Right_ext 0.5 P'') BPICT Q'')
    OPICT
    (extend_picture_frame Vertic_ext 0.2
      ((extend_picture_frame Right_ext 0.5 R'') BPICT S'')))
    OPICT'
    (make_text_picture  "The 4 basic pictures" {Name="Helvetica";Size=12.0}) (Gra 0.0)));;

let [T';U'] =  map
                    ((scale_picture (80.0,80.0))
                      o
                    (extend_picture_frame All_ext 0.1))
               [T;U];;

let T'' = T' OPICT' (make_text_picture  "quartet(A,B,C,D)" {Name="Helvetica";Size=12.0} (Gra 0.0));;
let U'' = U' OPICT' (make_text_picture  "cycle(rot B)" {Name="Helvetica";Size=12.0}(Gra 0.0));;

let FIG3 =
    (extend_picture_frame Right_ext 0.4 T'') BPICT U'';;


let FIG4 =
   (extend_picture_frame Bottom_ext 0.05 (scale_picture (80.0,80.0) SL))
   OPICT'
   (make_text_picture  "Square Limit" {Name="Helvetica";Size=12.0} (Gra 0.0));;



let T =quartet(A,B,C,D);;

let U = cycle (rot B);;

let C0=U and L0 = rot T and T0=T;;

let C1= quartet(small C0,small(L0 BPICT T0)
               ,small((rot T0)OPICT(rot L0)), U)
and L1 = trio(small L0,small T0,rot T)
and T1 = trio(small L0,small T0, T);;

let C2= quartet(small C1,small (L1 BPICT T1)
               ,small((rot T1)OPICT(rot L1)), U)
and L2 = trio(small L1,small T1,rot T)
and T2 = trio(small L1,small T1, T);;

let corner= quartet(small C2,small L2,
                    small(rot T2),rot B);;

let SL' = cycle corner;;

let FIG5 =
   (extend_picture_frame Bottom_ext 0.05 (scale_picture (4.0,4.0) SL'))
   OPICT'
   (make_text_picture  "Square Limit structure" {Name="Helvetica";Size=12.0} (Gra 0.0));;

echo_values true;;






