(*************************************************************************)
(*                                                                       *)
(*                     Projet      Formel                                *)
(*                                                                       *)
(*                    CAML: users' library                               *)
(*                                                                       *)
(*************************************************************************)
(*                                                                       *)
(*                            LIENS                                      *)
(*                        45 rue d'Ulm                                   *)
(*                         75005 PARIS                                   *)
(*                            France                                     *)
(*                                                                       *)
(*************************************************************************)

(* graphics_defaults.ml                                                  *)
(*              Emmanuel Chailloux & Guy Cousineau                       *)

module graphics_defaults
using
type frame = {!xmin:float;!xmax:float;!ymin:float;!ymax:float};
type color = Rgb of float * float * float
           | Hsb of float * float * float
           | Gra of float;
type linecap = Buttcap | Squarecap | Roundcap;
type linejoin = Beveljoin | Roundjoin | Miterjoin;
type linestyle = {linewidth:float;
                  linecap:linecap;
                  linejoin:linejoin;
                  dashpattern:int list};
type fillstyle = Nzfill | Eofill;
type graphic_state =
  {!color : color;
   !linewidth:float;
   !linecap:linecap;
   !linejoin:linejoin;
   !dashpattern:int list;
   !fillstyle : fillstyle};;

let default_display_frame = 
             {xmin=100.0;xmax=500.0;ymin=100.0;ymax=500.0};;

let default_graphic_state =
    {linewidth = 1.0;
     linecap = Roundcap;
     linejoin = Roundjoin;
     dashpattern=[];
     fillstyle = Eofill;
     color = Gra 0.0};;


let default_color () =
  default_graphic_state.color;;
   
let default_fillstyle () =
  default_graphic_state.fillstyle;;
   

let default_linestyle () =
  let dgs=default_graphic_state
  in
   {linewidth=dgs.linewidth;
    linecap=dgs.linecap;
    linejoin=dgs.linejoin;
    dashpattern=dgs.dashpattern};;


let set_default_display_frame (a,b,c,d) =
   let cdf = default_display_frame
   in  cdf.xmin<-a;
       cdf.xmax<-b;
       cdf.ymin<-c;
       cdf.ymax<-d;;

let set_default_color c =
   default_graphic_state.color <- c;;

let set_default_linewidth n =
   default_graphic_state.linewidth <- n;;

let set_default_linecap cap =
   default_graphic_state.linecap <- cap;;

let set_default_linejoin join =
   default_graphic_state.linejoin <- join;;

let set_default_dashpattern dp =
   default_graphic_state.dashpattern <- dp;;


end module
with
value default_display_frame
  and default_graphic_state
  and default_color
  and default_linestyle
  and default_fillstyle
  and set_default_display_frame
  and set_default_color
  and set_default_linewidth
  and set_default_linecap
  and set_default_linejoin
  and set_default_dashpattern;;

