\begin{verbatim}
overload ... with ...
#arith ...
-
\end{verbatim}
\conceptindex{\verb"overload ... with ..."}
\conceptindex{\verb"#arith ..."}
\conceptindex{\verb"-"}
\begin{caml_primitive}
get_arith_overloading : unit -> arith list
prefix + : int * int -> int
prefix * : int * int -> int
prefix ** : int * int -> int
prefix - : int * int -> int
prefix / : int * int -> int
prefix <= : int * int -> bool
prefix < : int * int -> bool
prefix >= : int * int -> bool
prefix > : int * int -> bool
float : int -> float
pred : int -> int
succ : int -> int
incr : int ref -> int
decr : int ref -> int
prefix quo : int * int -> int
prefix mod : int * int -> int
max : int -> int -> int
min : int -> int -> int
abs : int -> int
prefix power : int * int -> int
\end{caml_primitive}

Most of the operations on numbers are appliable to almost every kind
of numbers, e.g. basic arithmetic operations like \verb"+", \verb"*",
\verb"-" and \verb"/". Some others are specialized for one precise
kind of numbers as is the primitive operation \verb"succ_int : int -> int". 

Roughly speaking, the overloading lets the user not worry about all
these subtleties about numbers, especially in the non-standard
arithmetic mode. On numerical overloading see section~\ref{numover}. 

Symbols can be overloaded with the \verb"overload" construction as in:
\begin{small}
\begin{verbatim}
overload f with g;;
\end{verbatim}
\end{small}
where $f$ is the overloaded symbol and $g$ is the function which is called 
when $g\;(x)$ is well-typed in the context of the application of $f$
to argument $x$.

By default no numerical overloading is performed. The preceding functions are 
defined on type \verb"int" in standard arithmetic, else \verb"num". 

\verb"#arith arithmetic_type" loads a set of predefined usual overloading 
declarations for type \verb"arithmetic_type". 
The possible types are: int, float, big\_int, ratio, num.

\verb"#arith overloading" loads a set of predefined usual overloading 
declarations for types int, num and float.

\verb"get_arith_overloading ()" indicates for which numerical types
the predefined overloading mechanism is active.
