\begin{caml_primitive}
int_of_num : num -> int
num_of_int : int -> num
is_int : num -> bool
\end{caml_primitive}
\conceptindex{coercion between \verb"int"s and \verb"num"s}
\conceptindex{\verb"is_integer_num"}

\verb"int_of_num n" is the \verb"int" representing the rational number
\verb"n" if \verb"n" fits in an \verb"int".

\verb"num_of_int" maps an \verb"int" onto the corresponding \verb"num".

\verb"is_int" is equivalent to:
\begin{small}
\begin{verbatim}
let is_int = function 
  Int _ -> true 
|    _  -> false
;;
\end{verbatim}
\end{small}

\begin{beware}
\item No normalization is performed in this function,  so if applied
to an \verb"int" with not optimized constructor, the result is
false. This is possible only if you type in a ``small'' integer with a
label \verb"Big_int" or \verb"Ratio".
\end{beware}
  
\exple
\begin{small}
\begin{verbatim}
#int_of_num #{1.2e3};;
1200 : int

#int_of_num (succ_num (num_of_int biggest_int));;

Evaluation Failed: failure "int_of_big_int"

#int_of_num (pred_num (num_of_int least_int));;
-32768 : int

#num_of_int #1;;
#{1} : num
\end{verbatim}
\end{small}
