\begin{caml_primitive}
nat_of_ratio : ratio -> nat
ratio_of_nat : nat -> ratio
\end{caml_primitive}
\conceptindex{coercion between types \verb"nat" and \verb"ratio"}

\verb"nat_of_ratio r" maps rational number \verb"r" onto the corresponding 
\verb"nat", if \verb"r" is an integer and positive.

\verb"ratio_of_nat" maps naturally a \verb"nat" onto the corresponding
rational number. 

\exple
\begin{small}
\begin{verbatim}
#nat_of_ratio #[1.2e3];;
#<1200> : nat

#nat_of_ratio #[-1.2e3];;

Evaluation Failed: failure "nat_of_ratio"

#nat_of_ratio #[1.2];;

Evaluation Failed: failure "nat_of_ratio"

#nat_of_ratio #[1/2];;

Evaluation Failed: failure "nat_of_ratio"
\end{verbatim}
\end{small}
