\begin{caml_primitive}
eq_float : float * float -> bool
lt_float : float * float -> bool
le_float : float * float -> bool
gt_float : float * float -> bool
ge_float : float * float -> bool
abs_float : float -> float
max_float : float -> float -> float
min_float : float -> float -> float
\end{caml_primitive}
\conceptindex{\verb"<="}
\conceptindex{\verb"="}
\conceptindex{\verb">="}
\conceptindex{\verb"<"}
\conceptindex{\verb">"}
\conceptindex{\verb"max"}
\conceptindex{\verb"min"}
\conceptindex{\verb"abs"}

\verb"eq_float" is the semantic and syntactic equality on floating point 
numbers.

\verb"lt_float", \verb"le_float", \verb"gt_float", \verb"ge_float" are 
arithmetic comparisons corresponding respectively to \verb"<", \verb"<=", 
\verb">", \verb">=".

\verb"abs_float n" is the absolute value of the number \verb"n". 

\verb"max_float f1 f2" and \verb"min_float f1 f2" are respectively the 
greater and the smaller of the numbers \verb"f1" and \verb"f2".

\exple
\begin{small}
\begin{verbatim}
#eq_float (#3.402e38, #3.403e38);;
false : bool

#eq_float (#3.403e38, #3.404e38);;
true : bool

#lt_float (#3.402e38, #3.403e38);;
true : bool

#lt_float (#3.403e38, #3.404e38);;
false : bool

#gt_float (#3.403e38, #3.404e38);;
false : bool

#abs_float #-3.0;;
3.0 : float

#max_float #1.0 #2.0;;
2.0 : float

#min_float #1.0 #2.0;;
1.0 : float
\end{verbatim}
\end{small}
