\begin{caml_primitive}
compare_digits_nat  : nat * int * nat * int -> int
compare_nat : nat * int * int * nat * int * int -> int
eq_nat : nat * int * int * nat * int * int -> bool
le_nat : nat * int * int * nat * int * int -> bool
ge_nat : nat * int * int * nat * int * int -> bool
lt_nat : nat * int * int * nat * int * int -> bool
gt_nat : nat * int * int * nat * int * int -> bool
\end{caml_primitive}
\subsubsection{Comparison between digits}
\verb"compare_digits_nat (nat1, off1, nat2, off2)" returns -1 if digit
$nat1_{off1}$ is less than digit $nat2_{off2}$, 0 if they are equal
and 1 otherwise.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#compare_digits_nat (nat, #0, nat, #0);;
0 : int

#compare_digits_nat (nat, #0, nat, #1);;
-1 : int

#compare_digits_nat (nat, #1, nat, #0);;
1 : int

#complement_nat (nat, #0, #2);;
() : unit

#debug_print_nat nat;;
|00000003|00000002|FFFFFFFE|FFFFFFFF|() : unit

#compare_digits_nat (nat, #0, nat, #0);;
0 : int

#compare_digits_nat (nat, #0, nat, #1);;
1 : int

#compare_digits_nat (nat, #1, nat, #0);;
-1 : int
\end{verbatim}
\end{small}

\subsubsection{Comparison between natural numbers}
\verb"compare_nat (nat1, off1, len1, nat2, off2, len2)" returns -1 if
subnat $nat1_{off1, len1}$ is less than subnat $nat2_{off2, len2}$, 0
if they are equal and 1 otherwise.  

\begin{beware} 
\item For speed, if $len1 \neq len2$ then $compare\_nat (nat1, off1,
len1, nat2, off2, len2) = compare\_int (len1, len2)$. 
So if one of the indicated length is greater than the real length of the 
corresponding subnat, the result of this comparison may be wrong.
\end{beware} 

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #2 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000000|00000002|00000001|00000000|() : unit

#compare_nat (nat, #1, #2, nat, #0, #2);;
1 : int

#compare_nat (nat, #2, #2, nat, #2, #1);;
1 : int

#compare_nat (nat, #3, #2, nat, #3, #1);;
1 : int
\end{verbatim}
\end{small}

\verb"eq_nat", \verb"le_nat", \verb"ge_nat", \verb"lt_nat" and \verb"gt_nat" 
can be defined as follows :
\begin{small}
\begin{verbatim}
let eq_nat args = eq_int (compare_nat args, #0)
and le_nat args = le_int (compare_nat args, #0)
and ge_nat args = ge_int (compare_nat args, #0)
and lt_nat args = lt_int (compare_nat args, #0)
and gt_nat args = gt_int (compare_nat args, #0)
;;
\end{verbatim}
\end{small}
