\begin{caml_primitive}
length_of_int : int
biggest_int : int
least_int : int
monster_int : int
\end{caml_primitive}
\conceptindex{integer}
\conceptindex{\verb"int"}
Elements of type \verb"int" are small integers represented on 
\verb"length_of_int" bits, in the range (\verb"least_int, biggest_int"), 
more exactly the ring of the integers between \verb"least_int - 1" and 
\verb"biggest_int", since there is no notion of overflow.

This special value \verb"monster_int = least_int - 1" will be further 
discussed (see section~\ref{abs}).

Integer values of type \verb"int" are manipulated for the sake of efficiency 
(they are not allocated, hence there is no need to garbage collect them).

The maximum number of bits, the maximum, minimum and extremum values
of an \verb"int" are:

\begin{small}
\begin{verbatim}
#length_of_int;;
15 : int

#biggest_int;;
32767 : int

#least_int;;
-32767 : int

#monster_int;;
-32768 : int
\end{verbatim}
\end{small}
