\begin{caml_primitive}
sys_string_of_big_int  : int * string * big_int * string -> string
string_of_big_int : big_int -> string
string_for_read_of_big_int : big_int -> string
sys_print_big_int : int * string * big_int * string -> unit
print_big_int : big_int -> unit
print_big_int_for_read  : big_int -> unit
\end{caml_primitive}
\conceptindex{coercion between types \verb"big_int" and \verb"string"}

\verb"sys_string_of_big_int (base, before, bi, after)" writes into the 
resulting string first the string \verb"before", then the representation of 
the \verb"big_int" \verb"bi" in the base \verb"base", and finally the
string \verb"after". 

This function is equivalent to:
\begin{small}
\begin{verbatim}
let sys_sys_string_of_big_int (base, before, bi, after) =
 sys_string_of_nat (base,
                    (if eq_int (bi.Sign, #-1)
                        then (before ^ "-") else before),
                    bi.Abs_Value, #0, num_digits_big_int bi, after)
;;
\end{verbatim}
\end{small}

\verb"string_of_big_int bi" is equivalent to:
\begin{small}
\begin{verbatim}
let string_of_big_int bi = 
  sys_string_of_big_int (#10, "", bi, "")
;;
\end{verbatim}
\end{small}

\verb"string_for_read_of_big_int bi" is analogous to
\verb"string_of_big_int bi" except that the number is written between
\verb"#(" and \verb")", according to conventions to write \verb"big_int"s.

It is equivalent to:
\begin{small}
\begin{verbatim}
let string_for_read_of_big_int bi =
 sys_string_of_big_int (#10, "#(", bi, ")")
;;
\end{verbatim}
\end{small}

\verb"sys_print_of_big_int (base, before, bi, after)" prints the 
\verb"base"-radix representation of the \verb"big_int"
\verb"bi" between strings \verb"before" and \verb"after".

\verb"print_big_int" and \verb"print_big_int_for_read nat" are equivalent to:
\begin{small}
\begin{verbatim}
let print_big_int bi = sys_print_big_int (#10, "", bi, "");;

let print_big_int_for_read bi = sys_print_big_int (#10, "#(", bi, ")");;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_string_of_big_int 
#  (#16, "big_int 16-radix representation = ", #(1.2e3), "");;
"big_int 16-radix representation = 4B0" : string

#sys_string_of_big_int (#2, "big_int 2-radix representation = ", #(1.2e3), "");;
"big_int 2-radix representation = 10010110000" : string

#sys_string_of_big_int (#8, "big_int 8-radix representation = ", #(1.2e3), "");;
"big_int 8-radix representation = 2260" : string

#sys_string_of_big_int 
#  (#10, "big_int 10-radix representation = ", #(1.2e3), "");;
"big_int 10-radix representation = 1200" : string

#string_of_big_int #(1.2e3);;
"1200" : string

#string_for_read_of_big_int #(1.2e3);;
"#(1200)" : string

#sys_print_big_int (#16, "big_int 16-radix representation = ", #(1.2e3), "");;
big_int 16-radix representation = 4B0() : unit

#print_big_int #(1.2e3);;
1200() : unit

#print_big_int_for_read #(1.2e3);;
#(1200)() : unit
\end{verbatim}
\end{small}
