\begin{caml_primitive}
string_of_float : float -> string
string_for_read_of_float : float -> string
display_float : float -> unit
print_float : float -> unit
print_float_for_read : float -> unit
\end{caml_primitive}
\conceptindex{coercion between types \verb"float" and \verb"string"}
\conceptindex{\verb"print"}
\conceptindex{printing}

\verb"string_of_float" and \verb"string_for_read_of_float" map elements of 
type \verb"float" onto corresponding elements of type \verb"string".
\verb"string_for_read_of_float" adds the sharp character \verb"#" before the 
number according to the lexical convention for numbers of type \verb"float". 

\verb"display_float" prints in a trivial way (i.e. without formatting its 
argument) floating point numbers.

\verb"print_float" is the formatting function for floating point numbers. 

\verb"print_float_for_read" prints floating point numbers such that it is 
readable by the CAML system.

On the one hand, \verb"display_float" and \verb"print_float" print
floating point numbers without printing sharp character \verb"#". On
the other hand, \verb"print_float_for_read" prints floating point
numbers with sharp character \verb"#". 

For more details on the differences between \verb"display"- and \verb"print"- 
and \verb"print_*_for_read"-like functions see chapter ``Formatting Functions'' 
in the reference manual. 

\exple
\begin{small}
\begin{verbatim}
#string_of_float #123.45;;
"123.45" : string

#string_for_read_of_float #123.45;;
"#123.45" : string

#print_float #1.0;;
1.0() : unit

#print_float_for_read #1.0;;
#1.0() : unit
\end{verbatim}
\end{small}
