\begin{caml_primitive}
sys_latex_print_ratio : int * string * ratio * string -> unit
latex_print_ratio : ratio -> unit
latex_print_for_read_ratio : ratio -> unit
sys_print_beautiful_ratio : int * string * ratio * string -> unit
print_beautiful_ratio : ratio -> unit
\end{caml_primitive}
These special printing functions for rational numbers can be found
into two libraries:
\begin{description}
\item[format\_latex\_numbers.ml: ] functions that split numbers into
small lines so \LaTeX \, is able to handle them correctly,
\item[format\_numbers.ml: ] functions to present the rational number as
a numerical table according to common conventions.
\end{description}

\verb"sys_latex_print_ratio (base, before, r, after)" prints 
\verb"base" representation of the rational number \verb"r" between 
\verb"before" and \verb"after", cutting line each \verb"latex_margin"
characters. 

\verb"latex_print_ratio" and \verb"latex_print_for_read_ratio" are 
equivalent to:
\begin{small}
\begin{verbatim}
let latex_print_ratio r = sys_latex_print_ratio (#10, "", r, "")

and latex_print_for_read_ratio r = sys_latex_print_ratio (#10, "#[", r, "]")
;;
\end{verbatim}
\end{small}
As an example this manual uses \verb"latex_print_for_read_ratio" as the 
printer for rational numbers.

\verb"sys_print_beautiful_ratio (base, before, r, after)" prints 
\verb"base"-radix representation of the rational number \verb"r" between 
\verb"before" and \verb"after" as a numerical table according to classical 
conventions.

\verb"print_beautiful_ratio" is equivalent to:
\begin{small}
\begin{verbatim}
let print_beautiful_ratio r = 
  sys_print_beautiful_ratio (#10, "", r, "")
;;
\end{verbatim}
\end{small}

You can load the libraries with:
\begin{small}
\begin{verbatim}
load_lib_file "format_latex_numbers";;
load_lib_file "format_numbers";;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#print_beautiful_ratio #[1.2e3/1.1e2];;
120/11() : unit

#print_beautiful_ratio #[12345e105/1.1e2];;
12345 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 0000
/11() : unit

#print_beautiful_ratio #[12345e1/1.1e201];;
2469/
22000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
00000 00000  00000 00000  00000 00000  00000 00000  00000 00000
() : unit
\end{verbatim}
\end{small}
