-- Copyright (C) 1987 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "errortype.t"
#include "lexfuncs.t"
#include "symtab.t"
#include "syntaxt.t"

export lex;

-- lex : convert a string of characters to a list of lexical tokens

lex = lex emptytab where rec
    local
	idchar c = isalnum c | c = '_' | c = '.'
    and rec
	skipcomm ('*'.'/'.tail) = tail
    ||  skipcomm ($.tail) = skipcomm tail
    and
	getaction ('\\'.'}'.tail) = let a,t = getaction tail in '}'.a,t
    ||  getaction ('}'.tail) = "",tail
    ||  getaction (x.tail) = let a,t = getaction tail in x.a,t
    ||  getaction "" = fail "Unexpected EOF\n"
    in rec
    	lex $ [] = []
    ||	lex symtab ('{'.tail) =
	    let a,t = getaction tail
	    in prsCACTION (parseattr a). lex symtab t
    ||  lex symtab ('|'.tail) = prsCBAR. lex symtab tail
    ||  lex symtab (':'.tail) = prsCCOLON. lex symtab tail
    ||  lex symtab ('%'.'%'.tail) = prsCMARK. lex symtab tail
    ||	lex symtab ('%'.tail) =
	    let
		i,t = take idchar tail
	    in let
		directives = [
		    "function", prsCFUNCTION;
        	    "include", prsCINCLUDE;
        	    "left", prsCLEFT;
        	    "nonassoc", prsCNONASSOC;
        	    "prec", prsCPREC;
        	    "return", prsCRETURN;
        	    "right", prsCRIGHT;
        	    "start", prsCSTART;
        	    "token", prsCTOKEN;
		    "", fail ("No directive at\n" @ head 50 tail)
		    ]
	    and
		error = fail ("Unknown directive: " @ i)
	    in
		assocdef i directives error . lex symtab t
    ||  lex symtab (inp as al.$) & (idchar al) =
	    let
	    	i,t = take idchar inp
	    in let
	    	idrep,symtab' = insert i symtab
	    in
	    	prsCID (idrep,i) . lex symtab' t
    ||  lex symtab (';'.tail) = prsCSEMI symtab . lex symtab tail
    ||  lex symtab (' '.tail) = lex symtab tail
    ||  lex symtab ('\n'.tail) = lex symtab tail
    ||  lex symtab ('\t'.tail) = lex symtab tail
    ||  lex symtab ('/'.'*'.tail) = lex symtab (skipcomm tail)
    ||  lex $ (x.tail) =
	    	fail ("illegal char: " @ [x] @ " (" @ itos (ord x) @ ") at\n" @
			x.head 50 tail)
    end

end
