---------------------------------------------------------------
--   	TYPES
---------------------------------------------------------------
/* 	
   Associative-commutative theory T:
	   x * y     =   y * x
	(x * y) * z  =	x * (y * z)

   Set of rewrite rules R:
	x -> (y -> z)  =>  (x * y) -> z
         x -> y * z    =>  (x->y) * (x->z)   
 */

module

#include "setbag.t";

nonfix "Ar";
infix  "Ap";
infix  "App";
infixr "Arr";

export Operator, 
       Texp, 
       Nonspecial, 
       Factor;

-------	Abstract syntax for arbitrary expressions ------------- 

#define Variable (List Char)

#define OtherOp (List Char)

rec
    type Operator = Ar + X + Other OtherOp
and
    type Texp = Operator Ap (List Texp)
	      + V Variable
and

------- Abstract syntax for irreducible expressions  (normal forms) ------


#define Product (Bag Factor)

    type Nonspecial = OtherOp App (List Product) 
	            + VV Variable
and 
    type Factor = Product       -- argument types 
	          Arr
	          Nonspecial    -- result type, neither function nor pair


end
