------- sets and bags  ----------------------------

module

#include "aux.t"

export	Set,	-- type -> type
	Bag,    -- type -> type 

	set_of_list, -- List *a -> Set *a
	set_of_bag,  -- Bag *a  -> Set *a
	bag_of_list, -- List *a -> Bag *a
	bijections,  -- Set *a -> Set *b -> Set (*a -> *b) 
	set_exists,  -- (*a -> Bool) -> Set *a -> Bool
	empty_bag,   -- Bag *a
	singleton_bag,-- *a -> Bag *a
	bag_equal,   -- (*a -> *b -> Bool) -> *a Bag -> *b Bag -> Bool
	bag_map,     -- (*a -> *b) -> Bag *a -> Bag *b 
	bag_union,   -- Bag *a -> Bag *a -> Bag *a
	bag_flat;    -- Bag (Bag *a) -> Bag *a 

rec
    type Set *a = S (List *a)
and
    type Bag *a = B (List *a)
and
    set_of_list l    = S (mkset l)
and 
    set_of_bag (B l) = S (mkset l)
and
    bag_of_list l    = B l
and
    bijections (S l1) (S l2) =
	S (if  length l1 ~= length l2 
	   then  []
	   else  map (Cassoc o zip l1) (permutations l2))
and
    set_exists p (S l) = exists p l
and
    empty_bag       = B []
and
    singleton_bag a = B [a]
and
    bag_map f (B l)      = B (map f l)
and 
    bag_union (B l1) (B l2) = B (l1 @ l2)
and 
    bag_flat (B [])      = B []
 || bag_flat (B (b.bs)) = bag_union b (bag_flat (B bs))
and
    local rec
       remove1 p [] = Fail
    || remove1 p (x.xs) = if p x then Succeed xs
		        	 else case  remove1 p xs
			  	      in Fail : Fail
			  	      || Succeed ys : Succeed(x.ys)
				      end
    in
      bag_equal eq (B l1) (B l2) = 

        (length l1 = length l2)
	&
        (let rec
            bageq'  []    []    = true
         || bageq' (_._)  []    = false
         || bageq'  []   (_._)  = false
         || bageq' (x.xs) ys    = case  remove1 (eq x) ys
				  in  Fail : false
				  ||  Succeed(ys') : bageq' xs ys'
				  end
         in  bageq' l1 l2)
    end

end 
