-- Sum two numbers using feedback synced I/O and the "Form" function 
--
-- By A.Dwelly 28.3.89

#include "textio.t"

-- This program does the same job as sum2.m but with form style interaction
-- instead. The call to "Form" is
--
-- Form <form definition> <conversion function> <input list>
--
-- where the <form definition> is a list of "Formelem"s each of is
--
-- Formelem <xpos> <ypos> <recogniser list> <string>
--
-- The x and y positions are the position on the screen of the input field
-- the recogniser list is a list (usually with one element) of recognisers
-- and the input string is normally empty. 
--
-- The conversion function must have the type (List Strings) -> Whatever

let rec Sum l = 
    let (Out,OldForm,Input1,Rest) = Form [Formelem 30 10 [Number] "";
		   	                  Formelem 30 15 [Number] ""]
				    (map stoi) l

    in Clear @
       MoveTo 10 10 @ "First Number" @
       MoveTo 10 15 @ "Second Number" @
       Input1 @
       MoveTo 10 20 @ "The sum is " @ let [s1; s2] = Out in itos (s1+s2) @ "\n"

in [CCBREAK] @ Sum input

-- One important aspect is that you must not pattern match more than has
-- been used above in the call to "Form" eg
--
-- let ([s1;s2],OldForm,Input1,Rest) = Form etc
--
-- Will not work because of strict pattern matching. Perhaps this is an
-- argument for fully lazy pattern matching.
