module
infixr "::";
export Sprib, Sprx, Stream, Shd, Stl, Stail, Spr, Srep, Sf, St, Smap, Smap2;
rec (type Stream *a = *a :: (Stream *a))
and 	Shd (h::t) = h
and	Stl (h::t) = t
and	Stail 0 (h::t) = t
||	Stail n (h::t) = Stail (n-1) t

and Sf = false::Sf
and St = true :: St

/* Spr s: Make S (list of streams) to a printable string */
and Spr l = map (\x. if Shd x then '1' else '0') l @ "\n" @ Spr (map Stl l)

and Sprx f l = concmap (\x. f (Shd x) @ " ") l @ "\n" @ Sprx f (map Stl l)
and Sprib i b = concmap (\x. show_int (Shd x) @ " ") i @ 
		"[" @ concmap (\x. show_bool (Shd x) @ ";") b @ "]\n" @
		Sprib (map Stl i) (map Stl b)

/* Srep x n s: Repeat X N times and add stream S to the end */
and Srep _ 0 s = s
||  Srep x n s = x :: Srep x (n-1) s

and Smap f (s::sr) = f s :: Smap f sr
and Smap2 f (s1::s1r) (s2::s2r) = f s1 s2 :: Smap2 f s1r s2r
end
