--
-- $Header: /ufs/usr.src/local/lml/src/Expr/RCS/Egetid.m,v 1.7 88/05/08 20:39:04 augustss Exp $
--
module -- Egetid
--
-- Get ids from an expression (note: not only free, but in a renamed Expr
-- it usually doesn't matter).
-- The returned list contains duplicates to enable refernce counts.
--
#include "Expr.t.t"
#include "../expr/einfo.t.t"
export Egetid, Egetlamid;
rec
    Egetid (Eap e1 e2) = (Egetid e1)@(Egetid e2)
||  Egetid (Elam i e) = Egetid e
||  Egetid (Ecase e cies de) =
	conc (Egetid e.Egetid de.map (\(_,_,e).Egetid e) cies)
||  Egetid (Elet _ ies e) =
	conc (Egetid e.map (\(_,e).Egetid e) ies)
||  Egetid (Evar i) = [i]
||  Egetid (Econstr _ es) = concmap Egetid es
||  Egetid (Efailmatch _) = []
||  Egetid (Eidapl i es) = i.concmap Egetid es
||  Egetid (Elamapl _ e es) = conc(Egetid e.map Egetid es)
||  Egetid (Einfo f e) = Egf f @ Egetid e
||  Egetid _ = fail "Egetid"
and
    Egf (spark is) = is
||  Egf _          = []
and
-- Get all bound identifiers
    Egetlamid (Eap e1 e2) = (Egetlamid e1)@(Egetlamid e2)
||  Egetlamid (Elam i e) = i.Egetlamid e
||  Egetlamid (Ecase e cies de) =
	conc (Egetlamid e.Egetlamid de.map (\(_,is,e).is@Egetlamid e) cies)
||  Egetlamid (Elet _ ies e) =
	conc (Egetlamid e.map (\(i,e). i.Egetlamid e) ies)
||  Egetlamid (Evar i) = []
||  Egetlamid (Econstr _ es) = concmap Egetlamid es
||  Egetlamid (Efailmatch _) = []
||  Egetlamid (Eidapl i es) = concmap Egetlamid es
||  Egetlamid (Elamapl is e es) = conc(is.Egetlamid e.map Egetlamid es)
||  Egetlamid (Einfo f e) = Egetlamid e
||  Egetlamid _ = fail "Egetlamid"
end

