module
#include "../misc/pri.t"
#include "../misc/text.t.t"
#include "../misc/Tflat.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/constr.t.t"
#include "Gcodedef.t.t"

export Gprint;
rec
    Gprid i = Ts (idtostr i)

and Gprlabel (Label l) = Tl[Ts"L"; Ti l]
 || Gprlabel Notalabel = Ts"Lno"

and Gprbconstr(Gbint) = Ts"INT"
 || Gprbconstr(Gbchar) = Ts"CHAR"
 || Gprbconstr(Gbtag) = Ts"TAG0"
 || Gprbconstr(Gbfloat) = Ts"DFLOAT"
 || Gprbconstr(Gbinteger) = Ts"BIGNUM"

and Gprconstr(Gint) = Ts"INT"
 || Gprconstr(Gchar) = Ts"CHAR"
 || Gprconstr(Gstring s) = Tl[Ts"STRING \""; Ts s; Ts"\""]
 || Gprconstr(Gtype) = Ts"TYPE"
 || Gprconstr(Gfloat _) = Ts"FLOAT"
 || Gprconstr(Ginteger _) = Ts"INTEGER"

and Gprcasel l = Tl (map (\(i,n,l).Tl[pri "(^," [i]; Gprlabel l; Ts")" ]) l)

and Gprbas ADD = Ts"ADD"
 || Gprbas SUB = Ts"SUB"
 || Gprbas MUL = Ts"MUL"
 || Gprbas DIV = Ts"DIV"
 || Gprbas MOD = Ts"MOD"
 || Gprbas NEG = Ts"NEG"
 || Gprbas EQ  = Ts"EQ"
 || Gprbas NE  = Ts"NE"
 || Gprbas LT  = Ts"LT"
 || Gprbas GT  = Ts"GT"
 || Gprbas LE  = Ts"LE"
 || Gprbas GE  = Ts"GE"
 || Gprbas CHR = Ts"CHR"
 || Gprbas ORD = Ts"ORD"
 || Gprbas TAG = Ts"TAG"

and Gprall Aheap = Ts"HEAP"
 || Gprall Astack = Ts"STACK"

and Gpr (PUSH n) 	= pri "PUSH ^" [n]
 || Gpr (PUSHGLOBAL i) 	= Tl [Ts"PUSHGLOBAL "; Gprid i]
 || Gpr (EVAL) 		= Ts "EVAL "
 || Gpr (TEVAL)         = Ts "TEVAL"
 || Gpr (LABEL l) 	= Tl[ Gprlabel l; Ts":"]
 || Gpr (JMP l) 	= Tl[ Ts"JMP "; Gprlabel l]
 || Gpr (JFALSE l) 	= Tl[ Ts"JFALSE "; Gprlabel l]
 || Gpr (JTRUE l)       = Tl[ Ts"JTRUE "; Gprlabel l]
 || Gpr (JFUN i)	= pri "JFUN ^" [i]
 || Gpr (CALLFUN n)	= pri "CALLFUN ^" [n]
 || Gpr (UNWIND)	= Ts"UNWIND"
 || Gpr (ALLOC n)	= Tl[ pri "ALLOC ^" [n]]
 || Gpr (BCONSTR bc)	= Tl[ Ts"BCONSTR "; Gprbconstr bc]
 || Gpr (MKAP)		= Ts"MKAP"
 || Gpr (MKAPL(n))	= pri "MKAPL ^" [n]
 || Gpr (MKAPLV(n))	= pri "MKAPLV ^" [n]
 || Gpr (UPDATE n)	= pri "UPDATE ^" [n]
 || Gpr (MOVE n)	= pri "MOVE ^" [n]
 || Gpr (CONSTR c n m)	= Tl[ Ts"CONSTR " ; Gprconstr c; pri " ^ ^"[n;m] ]
 || Gpr (GETTAG)	= Ts"GETTAG"
 || Gpr (CASE n l ld)	= Tl[ pri"CASE ^ "[n]; Gprcasel l; Gprlabel ld]
 || Gpr (SPLIT bs cno n)= Tl [pri "SPLIT ^ ^ " [cno;n]; Ts (map (\x.if x then '1' else '0') bs)]
 || Gpr (BASICOP bo)	= Tl[ Ts"BASICOP "; Gprbas bo]
 || Gpr (BIGOP bo)	= Tl[ Ts"BIG"; Gprbas bo]
 || Gpr (PUSHBASIC x)	= pri "PUSHBASIC ^" [x]
 || Gpr (POP n)		= pri "POP ^" [n]
 || Gpr (GET)		= Ts"GET"
 || Gpr (GETMETHOD k)	= pri "GETMETHOD ^" [k]
 || Gpr (FUNSTART i n)	= Tl [Ts"FUNSTART "; Gprid i; pri " ^" [n] ]
 || Gpr (SFUNSTART i n) = Tl [Ts"SFUNSTART "; Gprid i; pri " ^" [n] ]
 || Gpr (FUNEND)	= Ts"FUNEND"
 || Gpr (RET)		= Ts"RET"
 || Gpr (JGLOBAL n i) 	= Tl [pri "JGLOBAL ^ " [n]; Gprid i]
 || Gpr (CALLGLOBAL n i)= Tl [pri "CALLGLOBAL ^ " [n]; Gprid i]
 || Gpr (JMETHOD n i) 	= Tl [pri "JMETHOD ^ ^" [n; i]]
 || Gpr (CALLMETHOD n i)= Tl [pri "CALLMETHOD ^ ^" [n; i]]
 || Gpr (SCALLGLOBAL n i)= Tl [pri "SCALLGLOBAL ^ " [n]; Gprid i]
 || Gpr (BUPDRET bc n)	= Tl[ Ts"BUPDRET "; Gprbconstr bc; pri " ^" [n]]
 || Gpr (CUPDRET c n m k)=Tl[ Ts"CUPDRET "; Gprconstr c; pri " ^ ^ ^"[n;m;k] ]
 || Gpr (AMODE a)	= Tl[ Ts"AMODE "; Gprall a ]
 || Gpr (SPARK)		= Ts"SPARK"
 || Gpr (CMVECTOR i is)	= Tl (Ts "CMVECTOR ".Gprid i.Ts "; ".map Gprid is)

and Gprint code =
	let f instr =
	   Tl [	
		let islabel (LABEL i) = true
		 || islabel _ = false
		in
		if islabel instr then Ts[] else Ts"\t";
		Gpr instr;
		Ts "\n"
	   ]
	in
	   Tflat (Tl (map f code)) []
end
