--
-- $Header: /ufs/usr.src/local/lml/src/expr/RCS/pprint.m,v 97.0 90/07/07 14:39:11 augustss Exp $
--
module -- pprint
--
-- prettyprinter
--
#include "id.t.t"
#include "constr.t.t"
#include "ttype.t.t"
#include "einfo.t.t"
#include "types.t.t"
#include "../transform/misc.t"
#include "id.t"
#include "ttype.t"
#include "einfo.t"
#include "../misc/flags.t"
#include "../misc/misc.t"
#include "constrfun.t"
#include "../syntax/listgen.h"
#include "impexp.t"
#include <Option>

export ppr, prdefg, prderiv;
rec
    ppr e = pr1 0 e @ "\n"
and
    primport (mkimport id imps fixs ents show exps rens) =
        "import " @ oprid id @ "..."
and prfix (mkfixid ids f) = prfixity f @ " " @ mix (map prid ids) ","
and prfixity (Infix p) = "infix "@itos p@" "
||  prfixity (InfixL p) = "infixl "@itos p@" "
||  prfixity (InfixR p) = "infixr "@itos p@" "
||  prfixity (FPrefix p) = "prefix "@itos p@" "
||  prfixity (FPostfix p) = "postfix "@itos p@" "
||  prfixity (Nonfix) = "nonfix "
||  prfixity Nofixity = ""
and
    issimple (mkident _) = true
 || issimple (mkconst _) = true
 || issimple (mkconstr _ []) = true
 || issimple _ = false
and ppr1 i e = if issimple e then pr1 i e else '(' . pr1 i e @ ")"
and prderiv None = ""
||  prderiv (Some is) = " deriving (" @ mix (map oprid is) "," @ ")"
and
    nli i = '\n' . space(4*i)
and optpr f None = ""
||  optpr f (Some x) = f x
and
    prdefg i d = (
	case d in
	   mkbtype t l od :
		(" type " @ prttype t @ " = " @ mix (map pratype l) " + " @ prderiv od
		where pratype (mkcons i lt) = 
		    mix (oprid i.map (\(t,b).prttype t@if b then "!" else "") lt) " ")
	|| mkbpat l :
		mix (map prbind l) (nli i @ "|| ")
	|| mkbmulti p e :
		prbind (p,e)
	|| mkband b1 b2 :
		(if isrec b1 then
			"(" @ prdefg i b1 @ ")"
		else
			prdefg i b1) @
		nli i @ "and " @ prdefg i b2
	|| mkblocal b1 b2  :
		"local " @ prdefg i b1 @ nli i @ " in " @ prdefg i b2 @ " end"
	|| mkbrec b :
		"rec " @ prdefg i b
	|| mkberror s :
		"ERROR " @ s
	|| mkbnull : "/* EMPTY */"
	|| mkbsyn t1 t2 : " type " @ prttype t1 @ " == " @ prttype t2
	|| mkbclass t b : " class " @ prcdecl t @ " where " @ nli (i+1) @ prdefg (i+1) b @ nli i @ "endclass"
	|| mkbinstance t b _ : " instance " @ pridecl t @ " where " @ nli (i+1) @ prdefg (i+1) b @ nli i @ "endinstance"
        || mkbdefault ts : " default (" @ mix (map prttype ts) "," @ ")"
	|| mkbsign is t : mix (map oprid is) "," @ " :: " @ prttype t
	end
	where isrec (mkbrec _) = true
	   || isrec _ = false
	and   prbind (ep,ee) = pr1 i ep @ " = " @ pr1 i ee)
and
    pr1 i e =
	case e in
	   mkmodule id _ imp exp def :
		nli i @ "module " @ oprid id @
		nli i @ "import " @ (if ImpDebug then mix (map primpid imp) ", " else "...")@";"@
		nli i @ "export " @ mix (map prexpid exp) ", " @ ";" @
		nli i @ prdefg i def @
		nli i @ "end"
	|| mkhmodule id exps imps fixs b :
	        nli i @ "hmodule " @ oprid id @ optpr (\x."(" @ mix (map prexpid x) "," @ ")") exps @
		concmap (\imp.nli i @ primport imp) imps @
		concmap (\fix.nli i @ prfix fix) fixs @
	        nli i @ prdefg i b
	|| mkident ii :
		oprid ii
	|| mkas ii ee :
		oprid ii @ " as " @ pr1 i ee
	|| mkcondp ep ec :
		pr1 i ep @ " & (" @ pr1 i ec @ ")"
        || mklazyp p : 
	        "~(" @ pr1 i p @ ")"
	|| mkinfo t e :
		preinfo t (ppr1 i e)
	|| mkconst c :
		case c in
		   cint ii : itos(ii)
		|| cchar c : ['\'';c;'\'']
		|| cstring s : '"' . s @ "\""
		|| cfloat s : s
		|| cinteger s : s
		|| crational s : s
		end
	|| mkap f a :
		(prapchain e
		where rec
		    prapchain (mkap fun arg) =
				if issimple arg then
					prapchain fun @ (' ' . pr1 i arg)
				else
					prapchain fun @ " (" @ pr1 i arg @ ")"
		||  prapchain e = ppr1 i e
		)
	|| mklam ide exp :
		('\\' . pr1 i ide) @ ('.' . pr1 i exp)
	|| mkletv def exp :
		nli i @ "let " @ prdefg i def @
		nli i @ "in " @ pr1 (i+1) exp
	|| mkcase exp casel :
		(nli i @ "case " @ pr1 i exp @ " in" @
		nli (i+1) @ mix (map prcasel casel) (" ||" @ nli (i+1)) @
		nli i @ "end "
		where prcasel(ep,ee) = pr1 (i+1) ep @ " : " @ pr1 (i+1) ee)
	|| mkerror s : "ERROR " @ s
	|| mkconstr c le & (isstring c) : '"'.cname c@"\""
	|| mkconstr c le : (
		 prc (cname c) @
#ifdef DEBUG
		(if Debug then "{" @ itos (cno c) @ ":" @ itos (nconstrs c) @ "}"
		 else "") @
#endif
		 (concmap (\e." "@ppr1 i e) le)
		 where prc ('_'.name) & (~Debug) = name
		 ||    prc x = x)
	|| mkfailmatch n : "DEFAULT_" @ itos n
	|| mklistf L_FROM [e] : "["@ pr1 i e @"..]"
	|| mklistf L_FROM_BY [e1;e2] : "[" @ pr1 i e1 @ ", " @ pr1 i e2 @ "..]"
	|| mklistf L_FROM_TO [e1;e2] : "[" @ pr1 i e1 @ " .. " @ pr1 i e2 @ "]"
	|| mklistf L_FROM_BY_TO [e1;e2;e3] : "[" @ pr1 i e1 @ ", " @ pr1 i e2 @ ".." @ pr1 i e3 @ "]"
	|| mklistg e qs : "["@pr1 i e @" ;; "@mix (map (prq i) qs) "; "@"]"
	|| _ : fail ("pr. unknown node:\n")
	end
and prq i (mkqgen p e) = pr1 i p @ " <- " @ pr1 i e
||  prq i (mkqfilter e) = pr1 i e
end
