module
#include "mcodedef.t.t"
#include "../Gcode/Gcodedef.t.t"
#include "Wuse.t"
#include "mutil.t"
#include "mutil1.t"
#include "mregs.t"
#include "mstrlbl.t"
#include "mstrid.t"
#include "handmade.mcode.t"
#include "../misc/flags.t"
export mcbasicret, mcnilret, mctagret, mcpairret, mbconstrret;
rec

local f a S greg = let r = reg(greg S []) in [ Mmove a r ], r
in
	   awayS (a as (Sind n)) S = f a S gareg
	|| awayS (a as (popS  )) S = f a S gareg
	|| awayS (a as (regind 0 m)) S = f a S gareg
	|| awayS (a as (reg 0)) S = f a S gareg
	|| awayS a S = [], a
	and
	   awayV (a as (popV))       V = f a V gdreg
	|| awayV (a as (regind 0 m)) V = f a V gdreg
	|| awayV a V = [], a
end

and
mcbasicret t g G bc x npop V S =
	let bcs = strbc bc in
	let (c, d, uv, us, k) = M t g G [] [] in

	    (	Mcom("CBASIC "@bcs@" "@itos x). Mcom("UPDATE "@itos(npop+1)).
		Mcom("POP "@itos npop). Mcom("RET").
	    	Mmove popV Sp.
		Mmove (Sind(-1)) (reg 0).
		(if Parallel then Mmove mupdtag (regind 0 0) else Mcom "").
		Mmove (const x)   (regind 0 1).
		Mmove (idlit bcs) (regind 0 0).
		Mreturn.c,
			d, allWpush, prepWuse npop allWpush, 0)

and
mcnilret t g G m npop V S =
	let (c, d, uv, us, k) = M t g G [] [] in
	    (	Mcom("CNIL "@itos m). Mcom("UPDATE "@itos(npop+1)).
		Mcom("POP "@itos npop). Mcom("RET").
	    	Mmove popV Sp.
		Mmove (Sind(-1)) (reg 0).
		(if Parallel then Mmove mupdtag (regind 0 0) else Mcom "").
		Mmove (const m) (regind 0 1).
		Mmove mniltag   (regind 0 0).
		Mreturn.c,
			d, allWpush, prepWuse npop allWpush, 0)

and
mctagret t g G m npop V aS =
	let (aa.S) = aS in
	let (c, d, uv, us, k) = M t g G [] [] in
	let (ca,a) = awayS aa []
	in
	    (	Mcom("CTAG "@itos m). Mcom("UPDATE "@itos(npop+1)).
		Mcom("POP "@itos npop). Mcom("RET").
	    	ca @
	    	Mmove popV Sp.
		Mmove (Sind(-1)) (reg 0).
		(if Parallel then Mmove mupdtag (regind 0 0) else Mcom "").
		Mmove (const m) (regind 0 1).
		Mmove a         (regind 0 2).
		Mmove mtagtag   (regind 0 0).
		Mreturn.c,
			d, allWpush, prepWuse (npop+1) allWpush, 0)

and
mcpairret t g G m npop V abS =
	let (aa.bb.S) = abS in
	let is = mpairtag m in
	let (c, d, uv, us, k) = M t g G [] [] in
	let (ca,a) = awayS aa [ bb ] in
	let (cb,b) = awayS bb [ a ]
	in
	    (	Mcom("CPAIR"). Mcom("UPDATE "@itos(npop+1)).
		Mcom("POP "@itos npop). Mcom("RET").
	    	ca @ cb @
	    	Mmove popV Sp.
		Mmove (Sind(-1)) (reg 0).
		(if Parallel then Mmove mupdtag (regind 0 0) else Mcom "").
		Mmove a  (regind 0 1).
		Mmove b  (regind 0 2).
		Mmove is (regind 0 0).
		Mreturn.c,
			d, allWpush, prepWuse (npop+2) allWpush, 0)


and
mbconstrret t g G bc npop aV S =
	let (aa.V) = aV in
	let bcs = strbc bc in
	let (c, d, uv, us, k) = M t g G [] [] in
	let (ca,a) = awayV aa []
	in
	    (	Mcom("BCONSTR "@bcs). Mcom("UPDATE "@itos(npop+1)).
		Mcom("POP "@itos npop). Mcom("RET").
	    	ca @
	    	Mmove popV Sp.
		Mmove (Sind(-1)) (reg 0).
		(if Parallel then Mmove mupdtag (regind 0 0) else Mcom "").
		Mmove a           (regind 0 1).
		Mmove (idlit bcs) (regind 0 0).
		Mreturn.c,
			d, Wuse.allWpush, prepWuse npop allWpush, 0)


end


