module
-- Generate a list (of ids) of possible derived instances
#include "../expr/types.t.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/tinfo.t"
#include "../expr/id.t.t"
#include "../expr/id.t"
#include "../expr/pprint.t"
#include "../transform/hexpr.t"
#include "../transform/genderiv.t"
#include "../transform/lettrans.t"
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "renenv.t"
#include "renameutil.t"
#include "../misc/util.t"
#include <Option>
#include <OK>
export solvederiv;
-- Solve the equation system that determines what can be derived.
-- This a hairy piece of code!  It's also very inefficient.  (Why include the Prelude every time?)
-- env is the environment created by this module, ienv is the imported (including Prelude) and
-- it should contain no automatic derivation.
--
rec solvederiv ff env ienv u =
    let einsts = map ininfo (filter id_isinst (rids Ktype env @ rids Ktype ienv)) in		-- explicit instance decls
    let tdefs = filter istdef (rids Ktype env) in						-- type decls
    let itdefs = filter istdef (rids Ktype ienv) in
    let (_, resx) = until eqls (itera einsts) ([], map info (itdefs@tdefs)) in
    -- We finally know what can be derived, correlate this with given info and generate instance id's
    let errs = filter (errchk resx) tdefs in
    let res = map (\(i,_,_,_,kds).(i, kds)) resx in
    let (biss, u') = Umap (geni ff res) tdefs u in
    let (bs, is) = split (conc biss) in
    let (iis, u'') = Umap (genimpid res) itdefs u' in
    let b = andify bs
    and env = rlist Ktype (is@conc iis) in
--    trace ("solve\n"@show_list show1 res@"\n-----\n"@show_list prid errs)
--    (trace (concmap (\b.prdefg 0 b@"\n\n") bs))
    (map oprid errs, env, b, u'')

and show1 = (\(x1,x2,x3,y,z).prttype (mktcons x1 (map mktvar x2))@ " = " @ show_list prttype y @ " " @ 
	                     show_list (show_pair((\x.show_list prttype (x3@x)),prid)) (z)@"\n")

-- limit derivation according to obvious constraints, and reshape data
and info (mkid _ _ (idi_type t _ ti _ od) _) =
    let cs = get_cs_from_tinfo ti in
    let ns = map (\(mkcons _ xs).length xs) cs in
    let (mktcons ti vs) = tpart t in
    (ti, map getv vs, cpart t, gettsfromcs cs, map (\d.([],d)) 
                                          (diffeq eqid (full od) 
					          (if all (\n.n = 0) ns then
						       []
					           else if length ns = 1 then
						       [hiEnum]
						   else
						       [hiEnum; hiIx])))

-- instance info: class name, type name, type vars, and context
and ininfo (mkid _ _ (idi_inst (mkidecl k ci ti vs) _ _) _) = (ci, ti, vs, k)

-- generate instance info from an type def. list
and iimpl (ti, vs, tk, _, kds) = map (\(k,d).(d, ti, vs, mkseteq eqass (tk@k))) kds
and eqass (mkassert i1 v1) (mkassert i2 v2) = eqid i1 i2 & v1 = v2
and ltass (mkassert i1 v1) (mkassert i2 v2) = ltid i1 i2

-- find type definitions that are interesting for deriving instances (ignore deriving ())
and istdef (mkid _ _ (idi_type _ _ ti _ x) _) = length (get_cs_from_tinfo ti) > 0 & ~ empty x
||  istdef _ = false
and empty (Some []) = true
||  empty _ = false
-- insert full derivation as first approx
and full (Some ds) = 
    -- complete with superclasses
    if member eqid hiEnum ds then
	mkseteq eqid (ds @ [hiEq; hiOrd; hiIx])
    else if member eqid hiIx ds then
	mkseteq eqid (ds @ [hiEq; hiOrd])
    else if member eqid hiOrd ds then
	mkseteq eqid (ds @ [hiEq])
    else
	mkseteq eqid ds
||  full None = if AutoDerive then [hiEq; hiOrd; hiIx; hiEnum; hiText; hiBinary] else []

and gettsfromcs cs = mkseteq eqtype (concmap (\(mkcons _ tbs).map (synexpandall o fst) tbs) cs)

-- compare two lists with instance info
and eqls (xs, ys) = And (map2 (\(_,_,_,_,xkds).\(y as (_,_,_,_,ykds)).And (map2 (\(xk,xd).\(yk,yd).eqid xd yd & seteq eqass xk yk) xkds ykds)) xs ys)

and itera eis (_, xs) = (xs, iter (eis @ concmap iimpl xs) xs)			-- make one iteration
and iter ais xs = map (iter1 ais) xs
and iter1 ais (ti, vs, k, ts, kds) = (ti, vs, k, ts, concmap (oned ais ts) kds)

and oned ais ts (_,d) = 
    case testconc (map (\t.ogetassert ais (d, t)) ts) in
	None : []
    ||  Some k : [(k,d)]
    end

-- get the assertions that makes a non-flat assertion true
and ogetassert its (d, (mktvar i)) = Some [mkassert d i]
||  ogetassert its (d, (mktcons ti ts)) =
    case getidt its d ti in
	None : None
    ||  Some (_, _, vs, k) :
             let al = combine (vs, ts) in
             let cn = map (ksubst al) k in
             testconc (map (ogetassert its) cn)
    end

and ksubst al (mkassert d v) = (d, assocdef v al (mktvar v))

and getv (mktvar v) = v
and gettvars tvs = map getv tvs

and getidt xs sci sti = findf xs (\(ci, ti, _, _).eqid ci sci & eqid ti sti) Some None

-- Check for bad deriv
and errchk xs (i as mkid _ _ (idi_type _ _ _ _ (Some ds)) _) =
    let rds = findf xs (\(j,_,_,_,_).eqid j i) (\(_,_,_,_,kds).map snd kds) (fail ("errchk lookup"@prid i)) in
    ~all (\d.member eqid d rds) ds
||  errchk _ _ = false

-- generate instance declarations for a type def
and geni ff xs i u = 
    let kds = assocdefeq eqid i xs (fail ("geni lookup"@prid i)) in
    Umap (geni1 ff xs i) kds u

and geni1 ff xs (i as mkid _ _ (idi_type ty _ ti _ _) _) (ks, d) u =
    let (mktcons tid tvs) = tpart ty in
    let t = mkidecl (cleanup (cpart ty @ ks)) d tid (gettvars tvs) in
    let (iid, u') = buildinstid ff u t t true in
    let (b, u'') = gender d (tpart ty) (get_cs_from_tinfo ti) u' in
    ((mkbinstance t b (Some iid), iid), u'')


-- clean up an assertion
and cleanup ks = sort ltass (mkseteq eqass ks)

-- Generate an instance id for imported derived stuff
and genimpid xs i u =
    let kds = assocdefeq eqid i xs (fail ("genimpid lookup"@prid i)) in
    Umap (genimp1 xs i) kds u

and genimp1 xs (i as mkid _ _ (idi_type ty _ ti _ _) (Orignames vi _ on)) (ks, d) u =
    let (mktcons tid tvs) = tpart ty in
    let t = mkidecl (cleanup (cpart ty @ ks)) d tid (gettvars tvs) in
    let ff = (\i.Orignames vi Nofixity (butlast on @ [idtostr i])) in
    buildinstid ff u t t true
end
