/*
 * Print Mcode for a function prelude, to interface with a C routine.
 *
 */


/* int intflag = 0; */

main(argc, argv)
  int argc; char **argv;
{
    char *pname = argv[0];
    int funflag = 0;

    argv++;
    argc--;
    if (strcmp(argv[0], "-") == 0) {
	funflag++;
	argv++;
	argc--;
    }
    if (argc != 4) {
	printf("Usage: %s [-] lml-name arity c-name include-file\n", pname);
	exit(1);
    }
    {
    char *name = argv[0];
    int arity = atoi(argv[1]);
    char *cname = argv[2];
    char *machdep = argv[3];
    int i;

    printf("#include \"%s\"\n", machdep);
    printf("\t.data\n");
    printf("\t.malign\n");
    printf("\t.export\tC_%s\n", name);
    printf("C_%s:\n", name);
    printf("LF10000:\n");
    printf("\t.word\tFUN\n");
    printf("\t.word\tVLF10000\n");
    printf("\t.export\tVC_%s\n", name);
    printf("VC_%s:\n", name);
    printf("VLF10000:\n");
    printf("\t.word\t$%d\n", arity);
    printf("\t.word\tLF10000\n");
    printf("\t.word\tunw%d\n", arity);
    printf("\t.word\tJ%dLF10000\n", arity);
    printf("\t.word\tvunw%d\n", arity);
    printf("\t.word\t$0\n");
    printf("\t.word\t$0\n");
    printf("\t.word\t$0\n");
    printf("\t.text\n");
    printf("\t.export\tS%dC_%s\n", arity, name);
    printf("S%dC_%s:\n", arity, name);
    printf("S%dLF10000:\n", arity);
    printf("\tmove\t$%d(Sp),Vpush\n", arity+1);
    printf("\t.export\tJ%dC_%s\n", arity, name);
    printf("J%dC_%s:\n", arity, name);
    printf("J%dLF10000:\n", arity);
    printf("\t.funbegin LF10000\n");
    for(i=0; i<arity; i++) {
	printf("\tmove\tSpop,r0\n");
	printf("\tCPUSHARG%d(r0)\n", i);
    }
    printf("\tmove\tSp,_ep\n");
    printf("\tmove\tHp,_hp\n");
    printf("\tCCALL(%d,%s)\n", arity, cname);
    printf("\tmove\t_hp,Hp\n");
    printf("\tmove\t_ep,Sp\n");
    if (funflag) {
        printf("\tmove\tCRETR,r0\n");
	printf("\tjumpf\tevalupdunw\n");
    } else {
        printf("\tmove\tCRETR,r1\n");
        printf("\tmove\tVpop,Sp\n");
        printf("\tmove\t-1(Sp),r0\n");
        printf("\tmove\t0(r1),0(r0)\n");
        printf("\tmove\t1(r1),1(r0)\n");
        printf("\tmove\t2(r1),2(r0)\n");
        printf("\treturn\n");
    }
    }
}
