#ifdef CRAY
#define SYSV
#define index strchr
#endif

#include <stdio.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/types.h>
#ifdef SYSV
#ifndef HZ
#define HZ 60		/* ??? */
#endif
#include <sys/termio.h>
#include <sys/times.h>
#else /* SYSV */
#include <sys/time.h>
#include <sys/timeb.h>
#include <sys/resource.h>
#include <sgtty.h>
#endif /* SYSV */

#define MKC 0                   /* Include C function to make nodes */
#define DUMP 1                  /* Include code to dump the graph */
#define GCSTAT 1		/* Enable GC statistics */

#define HCLAIM 1024		/* Max possible heapclaim (simple method) */

extern char *sbrk();
extern int getpid();
extern char *getenv();

/*
**	Flags to the runtime system.
*/
#if DUMP
int dflag = 0;	/* Stack dump at error 			*/
int Gflag = 0;	/* Stack dump before and after GC	*/
#endif /* DUMP */
#if GCSTAT
int sflag = 0;	/* Produce a brief STAT file		*/
int Sflag = 0;	/* Produce a verbose STAT file		*/
int Bflag = 0;	/* And sound the bell at GC		*/
#endif /* GCSTAT */
int uflag = 0;	/* Use unbuffered input and output	*/
int Hflag = 0;	/* Hiatonic input			*/
int Ttime = 0;	/* Hiaton timeout time			*/
int Cflag = 0;	/* Want core on BUS or SEGV		*/
int aflag = 0;	/* print extra space between outputs	*/
int debug = 0;
int MergeHiaton = 0;

int Gno = 1;
int **stopaddr, **chkaddr;

extern int **CCPmain[];            /* Pointer to main function */
extern int *argvnp[];
extern int *envpnp[];

int **stack;                    /* end of stack */
int **ep;			/* evaluation stack pointer 	*/
int **bos;			/* bottom of stack		*/

int **hp;			/* heap pointer			*/

int **ehp; 			/* end of current heap */
int **startheap, **endheap;	/* begin and end of the two heap halves */
int **curheap, **nxtheap;       /* current and other heap */

int stacksize = 100000;
int Heapsize = 1000000;
int MinHeapsize = 50000;
int heapsize;
int Minleft;			/* minimum heap left to continue execution */

FILE *mystdin = stdin;

extern int *PAIR1[], *TAG[], *STRING[], *INPUT[], *AP[], *TAG0[];

jmp_buf haltproc;
int done = 0;

#define NIL ((int **)0)

#if DUMP
#include "dump.c"
#endif /* DUMP */
#include "file.c"
#include "gc.c"
#include "news.c"
#include "print.c"
#include "error.c"

#if MKC
#include "mk.c"
#endif /* MKC */

#if GCSTAT
#include "gcstat.c"
#else /* GCSTAT */
#define GCstart(a1,a2,a3,a4)
#define GCend(a1,a2,a3,a4,a5)
#define GCstartup()
#define GCfinal(a1,a2)
#endif /* GCSTAT */

int
min(x,y)
int x,y;
{
    return x<y ? x : y ;
}

int
max(x,y)
int x,y;
{
    return x>y ? x : y ;
}

int **
mknode(tag, a1, a2)
int **tag, **a1, **a2;
{
    if(hp > ehp) {
	*--ep = (int *)a1;
	*--ep = (int *)a2;
	gcstack(0);
	a2 = (int **)*ep++;
	a1 = (int **)*ep++;
    }
    *hp++ = (int *)tag;
    *hp++ = (int *)a1;
    *hp++ = (int *)a2;
    return hp-3;
}

int **
mknode1(tag, a1)
int **tag, **a1;
{
    if(hp > ehp) {
	*--ep = (int *)a1;
	gcstack(0);
	a1 = (int **)*ep++;
    }
    *hp++ = (int *)tag;
    *hp++ = (int *)a1;
    return hp-2;
}

extern failfloat();
static jmp_buf jb;
cleansig()
{
#if 0
    if (setjmp(jb))
	return;
    longjmp(jb, 1);
#endif
    sigsetmask(0);
}

int intrflag = 0;
int doinggc = 0;
sigintr()
{
    extern int **realehp;
    extern int *csbegin[], **cspointer;
/*    fprintf(stderr, "intr\n");*/
    
    intrflag++;
    if (intrflag > 1) {
	if (!doinggc) {
	    intrflag = 0;
	    ehp = realehp;
	    cleansig();
	    failintr();
	}
    } else {
	if (cspointer < csbegin) {
	    /* There is an active catch */
	    ehp = 0;
	} else {
	    /* No active catch, remember that we had an intr */
	    /* intrflag is polled in catch */
	}
    }
}

int **
mkstring(s)
char *s;
{
   if (!*s)
     return mknode1(TAG0, NIL);
   else
     return mknode(PAIR1, mknode1(CHAR, *s), mkstring(s+1));
}

#ifdef CRAY
static int **
mkpstr(n, s)
int **n;
char *s;
{
    return mknode(PAIR1, mkstring(s), n);
}
#else

static int **
mkpstr(n, s)
int **n;
char *s;
{
    return mknode(PAIR1, mknode(STRING, (int **)s, NIL), n);
}
#endif

mkstrs(n, sp, pp)
int n;
char **sp;
int **pp;
{
    int **sap;
    int i;

    sap = mknode(TAG0, NIL, NIL);
    for (i = n-1; i >= 0; i--) {
	sap = mkpstr(sap, sp[i]);
    }
    pp[0] = sap[0];
    pp[1] = sap[1];
    pp[2] = sap[2];
}

char *flagtext[] = {
"The following run time flags are available:",
"",
"  -f	Prints this message and exits; the program is not executed.",
"  -d	Print a stack dump on error.",
"  -u	Unbuffered output; default is buffered.",
"  -B	Sound the bell at the start of garbage collection.",
"  -H	Set heap size, e.g. -H30000. Default is 2600000.",
"  -h	Set start size of heap. Default is 50000.",
"  -C	Produce a 'core' file after bus error or memory fault.",
"  -G	Print a stack dump before and after each garbage collection.",
"  -s	Produce a brief 'STAT' file, containing garbage collection statistics.",
"  -S	Produce a verbose 'STAT' file.",
"  -a	Print extra space after each printed item.",
"  -i f Take input from file f.",
"  -on f Print output on channel n on file f.",
"  -	Marks the end of decoded arguments.",
"",
0
};

char *progname;

main(argc, argv, envp)
int argc;
char **argv, **envp;
{
    char *s;

    progname = *argv;
    argc--;
    argv++;
    if (s = getenv("LMLHEAP"))
	Heapsize = decode(s) / sizeof(int *);
    while (argc && argv[0][0] == '-') {
	if (argv[0][1] == '\0')
	    break;
	while (*++*argv) {
	    switch (**argv) {
#if DUMP
		case 'M': 
		    maxdump = atoi(*argv + 1);
		    goto nextarg;
		case 't': 
		    dumpdepth = atoi(*argv + 1);
		    goto nextarg;
		case 'd': 
		    dflag++;
		    break;
		case 'G': 
		    Gflag++;
		    if (*argv + 1)
			Gno = atoi(*argv + 1);
		    goto nextarg;
		case 'K':
		    stopaddr = (int **)atox(*argv + 1);
		    goto nextarg;
		case 'Q':
		    chkaddr = (int **)atox(*argv + 1);
		    goto nextarg;
#endif /* DUMP */
#if GCSTAT
		case 'B': 
		    Bflag++;
		    break;
		case 'S': 
		    Sflag++;
		    break;
		case 's': 
		    sflag++;
		    break;
#endif /* GCSTAT */
		case 'u': 
		    uflag++;
		    break;
		case 'C': 
		    Cflag++;
		    break;
		case 'a': 
		    aflag++;
		    break;
		case 'h': 
		    MinHeapsize = decode(*argv + 1) / sizeof(int *);
		    goto nextarg;
		case 'H': 
		    Heapsize = decode(*argv + 1) / sizeof(int *);
		    goto nextarg;
		    break;
		case 'X':
		    debug++;
		    break;
#if 0
		case 'P':
		    Pflag++;
		    break;
#endif
		case 'T':
		    Hflag++;
		    Ttime = atoi(*argv + 1);
		    goto nextarg;
		    break;
		case 'i': 
		    if (--argc < 0) {
			fprintf(stderr, "No -i file\n");
			finish(1);
		    }
		    if (freopen(*++argv, "r", mystdin) == NULL) {
			fprintf(stderr, "Cannot open %s\n", *argv);
			finish(1);
		    }
		    goto nextarg;
		case 'o': {
		    int n;
		    n = (*argv)[1] - '0';
		    if (n < 1 || n > 9) {
			fprintf(stderr, "Bad -on\n");
			finish(1);
		    }
		    if (--argc < 0) {
			fprintf(stderr, "No -on file\n");
			finish(1);
		    }
		    if (ofiles[n]) {
			if (freopen(*++argv, "w", ofiles[n]) == NULL) {
			    fprintf(stderr, "Cannot open %s\n", *argv);
			    finish(1);
			}
		    } else {
			++argv;
			if (strcmp(*argv, "-") == 0)
			    ofiles[n] = fdopen(dup(1), "w");
			else if ((ofiles[n] = fopen(*argv, "w")) == NULL) {
			    fprintf(stderr, "Cannot open %s\n", *argv);
			    finish(1);
			}
		    }
		    goto nextarg;
		}
		default: 
		    fprintf(stderr, "**** Illegal flag ****\n");
		/* fall into ... */
		case 'f': 	/* Print an explanation of the v	
				 * run-time flags, and exit. */
		    {
			char  **p;
			for (p = flagtext; *p; p++)
			    printf("%s\n", *p);
		    }
		    finish(1);
	    }
	}
nextarg: ;
	argc--;
	argv++;
    }
    heapsize = MinHeapsize;
    if (Gflag)
	loadsymbols();
    Minleft = Heapsize / 300 + 1000;
    signal(SIGFPE, failfloat);

    setupstack();
    setupheap();
    hp = ch_hp;			/* Use ch_hp to allocate */

    { int i;
    for(i=0; envp[i] != 0; i++)
    	;
    mkstrs(i, envp, envpnp);
    }
    mkstrs(argc, argv, argvnp);

    if (!aflag)
	    setupsigs();
    if (!Cflag) {
	(void)signal(SIGBUS, sigbus);
	(void)signal(SIGSEGV, sigsegv);
	(void)signal(SIGILL, sigill);
    }
    if (uflag) {
	setbuf(stdout, NULL);
    }
    setbuf(stderr, NULL);

    GCstartup();

    PROCESSNO[1] = getpid();

#if MKC
    if(yyparse() != 0){
    	fprintf(stderr, "Syntax error, exit.\n");
	finish(1);
    }
    *--ep = (int *) parse_tree;
#endif /* MKC */
    *--ep = (int *) argvnp;
    *--ep = (int *) envpnp;
    *--ep = (int *) mknode(AP, CCPmain[0], mknode(INPUT, (int **)mystdin, NIL));
    ch_hp = hp;			/* Start allocation here */
    ehp = 0;			/* Force newchunk() at first allocation */
    newchunk(0);		/* Must allocate chunk here to make sure it is there when runtime system is first entered */

    printtop(ofiles[1]); /* evaluate and print the user program */

    if (aflag) fprintf(ofiles[1], "\n");

    GCfinal(curheap, hp);
    finish(0);
}

gcstack(f)
{
    newchunk(f);			/* TMP */
}

finish(r)
{
	set_tty(0);
	exit(r);
}

xsignal(s, intr)
int (*intr)();
{
    if (signal(s, SIG_IGN) != SIG_IGN)
	(void)signal(s, intr);
}

killme()
{
	finish(2);
}

setupsigs()
{
	xsignal(SIGINT, killme);
	xsignal(SIGHUP, killme);
	xsignal(SIGTERM, killme);
}

#ifdef SYSV
set_tty(set)
int set;
{
	static struct termio save, modes;
	static int sset = 0;
	if (set) {
	    if (!sset)
		ioctl(2, TCGETA, &save);
	    modes = save;
	    modes.c_lflag &= ~ICANON;
	    modes.c_lflag &= ~ECHO;
	    modes.c_cc[VMIN] = 1;
	    ioctl(2, TCSETA, &modes);
	    sset = 1;
	} else if (sset) {
	    ioctl(2, TCSETA, &save);
	}
}
#else
set_tty(set)
int set;
{
	static struct sgttyb save, modes;
	static int sset = 0;
	if (set) {
	    if (!sset)
		ioctl(2, TIOCGETP, &save);
	    modes = save;
	    modes.sg_flags |= CBREAK;
	    modes.sg_flags &= ~ECHO;
	    ioctl(2, TIOCSETP, &modes);
	    sset = 1;
	} else if (sset) {
	    ioctl(2, TIOCSETP, &save);
	}
}
#endif

int
decode(s)
char *s;
{
    int l, c;
    double m;
    extern double atof();

    if (!*s)
	return 0;
    m = atof(s);
    c = s[strlen(s)-1];
    if (c == 'm' || c == 'M')
	m *= 1000000;
    else if (c == 'k' || c == 'K')
	m *= 1000;
    return (int)m;
}

#ifdef CRAY
STOFERR()
{
	printf("Stack overflow\n");
	finish(1);
}

STOFJMP()
{
    printf("Stack failed to allocate in same chunk\n");
    finish(1);
}
#endif

int atox(s)
char *s;
{
    int i;

    sscanf(s, "%x", &i);
    return i;
}
