module -- sutil
#include "../expr/constr.t.t"
#include "../expr/constrfun.t"
#include "../expr/id.t.t"
#include "../expr/einfo.t.t"
#include "../Expr/Expr.t.t"
#include "../misc/setofid.t"
export cval, value, isc, refc, xgetid;
rec
    cval (Cconstr _ _ _ n _) = n
and value (Econstr c []) = cval c
-- Don't say that strings are constants since they have a peculiar
-- representation.
and isc (Econstr c _) = ~ isstring c
||  isc _ = false
and refc = map (\x.(hd x, length x)) o group Ieq o sort Ilt

-- Special version of Egetid that makes sure that we don't substitute inside lambda by
-- counting everything twice there.
and
    xgetid (Eap e1 e2) = (xgetid e1)@(xgetid e2)
||  xgetid (Elam i e) = dup (xgetid e)
||  xgetid (Ecase e cies de) =
	conc (xgetid e.xgetid de.map (\(_,_,e).xgetid e) cies)
||  xgetid (Elet _ ies e) =
	conc (xgetid e.map (\(_,e).xgetid e) ies)
||  xgetid (Evar i) = [i]
||  xgetid (Econstr _ es) = concmap xgetid es
||  xgetid (Efailmatch _) = []
||  xgetid (Eidapl i es) = i.concmap xgetid es
||  xgetid (Elamapl _ e es) = conc (dup (xgetid e).map xgetid es)
||  xgetid (Einfo f e) = xgf f @ xgetid e
||  xgetid _ = fail "xgetid"
and xgf (spark is) = is
||  xgf _          = []

and dup is = let is' = Imk is in is'@is'
end
