module -- check
--
-- $Header: /ufs/usr.src/local/lml/src/type/RCS/check.m,v 97.0 90/07/07 14:42:39 augustss Exp $
--
-- performs the actual type checking
--
-- The strictification (with let!) is a very small improvement,
-- but since I put it in it can stay...
--
#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/einfo.t.t"
#include "../expr/ttype.t.t"
#include "../expr/ttype.t"
#include "../expr/id.t"
#include "../expr/idtab.t"
#include "../expr/constrfun.t"
#include "../Expr/Expr.t.t"
#include "../Expr/Eprint.t"
#include "../Expr/Egetid.t"
#include "../Expr/unrec.t"
#include "../transform/misc.t"
#include "../misc/misc.t"
#include "../misc/util.t"
#include "../misc/flags.t"
#include "subst.t.t"
#include "prefix.t"
#include "subst.t"
#include "unify.t"
#include "conutil.t"
#include "check.t"

export Wdlh;

rec Wdlh p dl defs u = Wdl p defs (conc dl) u 

and prassert (mkassert i v) = prttype (mktcons i [mktvar v])

and cst ((c, _ ,_)._) = ctype c
and consinst c u = instTR (getTvars (cst c)) u
-- Add name of defined entity to error message.
and addterr i (bad es) = 
    let s = idtostr i in
    let s2 = head 2 s in
    if s2 = "MM" | s2 = "DD" then
	-- Take care of methods etc.
	bad (('_'.reverse (fst (splitat '.' (reverse s)))) . es)
    else
	bad (s.es)
||  addterr _ S = S

-- test if a definition is overloadable
-- this is a hack.
-- allow overloading for methods.
and isovl (i, e) =  isovle e | isovlid i
and isovle (Einfo overload _) = true
||  isovle (Einfo _ e) = isovle e
||  isovle (Elet _ _ e) = isovle e		-- maybe we need this?
||  isovle (Elam _ _) = true
||  isovle _ = false
and isovlid (mkid _ ('M'.'M'._) _ _) = true
||  isovlid (mkid _ ('D'.'D'._) _ _) = true
||  isovlid _ = false

and normt S t =
    if cpart t ~= [] then fail ("normt "@prttype t) else
    let vs = getTvars t in
    xmkcontype (extractcon vs S) t

and kvars (ok aas _) = mkset (map (\(mkassert _ v).v) aas)
||  kvars _ = []

and
    chkdefs top p (z as (_,defs)) u ds =
	let! (u1, STs) =
	    mapstate (\u.\(a,b).
                      let (Rw,r,D,b',u1) = W p z b u in
		      let Rr = resolvedefs Rw D defs (if top then startpre else TRprefix Rw p) r in	-- resolve everything on the top level
		      let R = ecombTR b Rw Rr in
		      (u1, (addterr a R, r, TRdict Rr D, (a,  b'))))
		     u ds
	in
	let! (Ss, Ts, Ds, ds') = split4 STs in
let rrr =
	(u1, combTRs Ss, Ts, ds', Ds)
in
if TestN > 1 then trace (force ("chkdefs "@show_list (prid o fst) ds' @ show_list prttype Ts)) rrr else
rrr

and
    Wdlnorm top p (it,defs) dl u =
	let rec (u1, R, xts, dl', Ds) = chkdefs top p (it', defs) u dl
        and     ts = map (TRtype R) xts
        and     it' = if noovl then it else reduce (\(i,e).\r.itadd1 r i e) it (conc iess)
        and     (xs, u2) = Umap3 (newdn R) dl' ts Ds u1
	and     (dl'', Ds', ts', iess) = split4 xs
        and     noovl = ~top & ~all isovl dl in
	if noovl then
	    Wlast top dl dl'  Ds  ts  p R u2
	else
	    Wlast top dl dl'' Ds' ts' p R u2
	    

and
    -- There is an extra complication with recursive definitions and contexts:
    -- the recursive call has to be changed as well, and all of the functions need
    -- the transitive closure of the contexts.
    Wdlrec top p (it, defs) dl u =
	let ul = u+length dl in
	let nt = for u (ul-1) mktvar in
	let rec (u1, Rc, dTs, dl', Ds) = chkdefs top (addngs (combine (map fst dl, nt)) p) (it', defs) ul dl
	and      Ss = map (\(dT, T).Unify T dT) (combine (dTs, nt))
	and      R = combTR (combTRs Ss) Rc
        and      tts = map (TRtype R) dTs
        and      ries = map (\(i,_).(i, caply (Evar i) (map Evar is))) dl
	and      is = map2 buildid curk (from u1)
        and      curk = extractcon (reduce union [] (map getTvars tts)) R
        and      (xs, u2) = Umap3 (newd R curk is) dl' tts Ds (u1 + length curk)
        and      (dl'', Ds', ts', iess) = split4 xs
        and      it' = if noovl then it else reduce (\(i,e).\r.itadd1 r i e) it (conc (ries.iess))
        and      noovl = ~top & length dl = 1 & ~all isovl dl in
	if noovl then
	    Wlast top dl dl'  Ds  tts p R u2
	else
	    Wlast top dl dl'' Ds' ts' p R u2

and Wlast top dl dl'' Ds' ts' p R u2 =
	let pre = combine (map fst dl, ts') in
        let p' = TRprefix R p in
        -- ng are those type vars that should not be considered generic because of overloading constraints
        let ng = reduce union [] (map2 (\d.\t.if isovl d then [] else intersect (difference (getTvars t) (getngs p')) (kvars R)) dl ts') in
        let np = addpreng pre p' ng in
let rrr =
--        if top & ~ null ng then
--	    (bad ["Sorry, cannot have monomorphic top level constants yet: "@mixmap (oprid o fst) dl ", "], np, combdicts Ds', dl'', u2)
--	else
	    (prunecontext (getngs np) R, np, combdicts Ds', dl'', u2)
in
if Test then trace (force("Wlast\n"@prTR R@prpre np)) rrr else
rrr


and Dnil = []
and
    W p z f u =
let (rrr as (R, t, d, e, u)) = 
	case f in
	   Einfo (restr t) e :
		let! (R, r, D, e', u1) = W p z e u in
		let! (tn, u2) = inst t (getTvars t) u1 in
		let U = Unify r tn in
		let V = ecombTR f R U in
		-- check that restr. are not inst.
		let V1 = chkgen (count u1 (u2-1)) V r tn (getngs p) in
                let V2 = reorder V1 tn in
		(pruneTR u V2, TRtype V2 (tpart tn), TRdict V2 D, e', u2)		-- use tn instead of r to get type in the asked for shape
	|| Einfo (trestr t) e :
		let! (R, r, D, e', u1) = W p z e u in
		let U = Unify r t in
		let V = ecombTR f R U in
		(pruneTR u V, TRtype V r, TRdict V D, Einfo (trestr t) e', u1)
	|| Einfo notchk e :				-- No typecheck here, assume a fresh variable
	        (emptyTR, mktvar u, Dnil, f, u+1)
	|| Einfo f e :
		let! (R, r, D, e', u1) = W p z e u in
		(R, r, D, e', u1)
	|| Eap d e :
		let! (R, r, D1, d', u1) = W p z d u in
		let! (S, s, D2, e', u2) = W p z e u1 in
		let beta = mktvar u2 in
		let U = Unify r (Tarr s beta) in
		let V = ecombTR f U (combTR S R) in
--trace("apply: "@pr f@" :: "@prttype (normt V (TRtype V beta)))
--trace ("apply "@force (pr d@prTR R)@" and "@force (pr e @ prTR S) @ force (" U="@prTR U) @ force ("V="@prTR V))
		(pruneTR u V, TRtype V beta, TRdict V (combdict D1 D2), Eap d' e', u2+1)
	|| Evar i :
		let! (typ, gl) = pfind i p in
		let! (t, un) = inst typ gl u in
		let! (D, e', u') = De z t f un in
let rrr =
		(ok (cpart t) [], tpart t, D, e', u')
in
--trace ("var "@pr f@" :: "@prttype t@" (was "@prttype typ@")")
if Test then trace ("Evar "@prid i@" "@prttype t@" was "@prttype typ@" dict ="@show_list (show_pair(prid, (show_pair(prid,prttype)))) D) rrr else
rrr
	|| Econstr (c as Cconstr _ ctyp _ _ ts) es :	       
		let! (T, u1) = instTR (getTvars ctyp) u in
		let! (u2, SDes) =
		    mapstate (\u.\(t,e).let (R, r, D, e', u1) = W p z e u in
					(u1, (ecombTR e (Unify r (T t)) R, D, e')))
			     u1
			     (combine (map fst ts, es))
		in
		let (Ss, Ds, es') = split3 SDes in
		let R = ecombTRs f Ss in
		let tn = T ctyp in
--trace ("constr "@pr f@" :: "@prttype (TRtype R (T ctyp)))
		(pruneTR u (addconTR (cpart tn) R), TRtype R (tpart tn), TRdict R (combdicts Ds), Econstr c es', u2)
	|| Elam i d :
		let tv = mktvar u in
		let! (R, r, D, d', u1) = W (addngens [(i, (tv, []))] p) z d (u+1) in
--trace ("lam "@pr f@" :: "@prttype (normt R (TRtype R (Tarr tv r))))
let rrr =
		(pruneTR u R, TRtype R (Tarr tv r), TRdict R D, Elam i d', u1)
in
if Test then trace ("lam "@prid i@" gets "@itos u) rrr else
rrr
	|| Efailmatch _ :
		(emptyTR, mktvar u, Dnil, f, u+1)
	|| Ecase e ces de :
		-- T is used to instanciate the typevars for the constructor
		let! (T, u1) = consinst ces u in
		let! (R0, eT, De, e', u2) = W p z e u1 in
		let R1 = echk e (Unify (T (cst ces)) eT) in
		let! (R2x, ResT, Dd, de', u3) = W p z de u2 in
		let R2 = echk de R2x in
		let! (u4, Tes) =
	mapstate (\u.\((c as Cconstr _ _ _ _ ts), is, e).
	    let! (V, r, D, e', u1) = W (addngs (combine(is, map (T o fst) ts)) p) z e u in
	    let U = Unify ResT r in
--trace ("case "@show_list (show_pair(prid,prttype)) (combine(is,map (T o fst) ts)))
	    (u1, (ecombTR e U V, D, (c, is, e'))))
	u3
	ces
		in
		let (Ts, Ds, ces') = split3 Tes in
		let S = ecombTRs f (Ts@[R2;R1;R0]) in
--trace (itos u@" "@prTR S)
		(pruneTR u S, TRtype S ResT, TRdict S (combdicts (De.Dd.Ds)), Ecase e' ces' de', u4)

	|| Elet r dl exp :
		let! (R, pref, D, dl', u1) = if r then Wdlrec false p z dl u
				              else Wdlnorm false p z dl u in
		let! (S, s, De, exp', u2) = W pref z exp u1 in
		let V = ecombTR f S R in
		(pruneTR u V, s, TRdict V (combdict D De), Elet r dl' exp', u2)
	end
in
if Test then trace ("start "@pr f@force ("W "@pr f@prttype t@"\n"@prTR R@prD d)) rrr else
rrr

and prD d = show_list (show_pair(prid,show_pair(prid,prttype))) d

and Wdl pre defs dl u = (f emptyTR pre u (sccds dl) []
    where rec f T p u [] xs = (T, p, u, reverse xs)
           || f T p u ((r, ds as (_,e)._).dss) xs =
        let ngp = getngp p in			-- A real hack for overloaded non-lambda bounds stuff.
	let (R, p', D, x, u') = if r then Wdlrec true p (itnil, defs) ds u else Wdlnorm true p (itnil, defs) ds u in
        let S = ecombTRs e [T; R] in
	if ~ (null D) & (case S in ok _ _ : true || _ : false end) then
	    fail ("Unresolved in Wdl "@show_list (show_pair(prid,show_pair(prid,prttype))) D)
	else
	    (f S (addngens ngp p') u' dss (x.xs)))

and De (it, def) t (e as Evar i) u =
--trace ("insert at "@pr e@" "@show_list prttype (cpart t))
(
    case cpart t in
	[] : ([], itlookupdef it i e, u)
    ||  k  : let n = length k in
	     let is = for u (u+n-1) (mknewid "D") in
	     (combine (is, map (\(mkassert d v).(d, mktvar v)) k), caply e (map (\i.itlookupdef it i (Evar i)) is), u+n)
    end
)
end
