signature LEXSTUFF = sig
  type arg
  type lexarg
  type ('a,'b) token
  type svalue
  type pos (* = int *)
  structure ErrorMsg :ERRORMSG
  sharing type pos = ErrorMsg.pos = int

  val addString : string list ref * string -> unit
  val ascii'dquote : int
  val ascii'zero : int
  val eof : {charlist:'a,comLevel:int ref,err:int * int -> ErrorMsg.severity -> string -> unit,lineNum:int ref,linePos:int list ref,stringstart:int ref} 
        -> (svalue,int) token
  val make'lexarg : ErrorMsg.pos2complainer -> lexarg
  val makeInt : (int * int -> int) -> string -> int
  val makeString : string list ref -> string
  val makeHexInt : (int * int -> int) -> string -> int
end
