functor ArgsFun
  (structure Data :DATA
   structure Group :GROUP
   sharing Data = Group.Data
  ) :ARGS = struct

structure Data = Data
open Data

fun getAutoFileList (desc :groupDescription, accum :string list)
                    :string list =
  (case desc of
      (Library _) => accum | (Include _) => accum | (Connections _) => accum
    | (Automatic namelist) => accum @ namelist | (Link _) => accum)

fun getConnFileList (desc :groupDescription, accum :string list)
                      :string list =
  (case desc of
      (Library _) => accum | (Include _) => accum | (Automatic _) => accum
    | (Connections namelist) => accum @ namelist | (Link _) => accum)

fun getLinkFileList (desc :groupDescription, accum :string list)
                      :string list =
  (case desc of
      (Library _) => accum | (Include _) => accum | (Automatic _) => accum
    | (Link namelist) => accum @ namelist | (Connections _) => accum)

fun getLibraryGroups (desc :groupDescription, accum :groupInfo list)
                     :groupInfo list =
  (case desc of
      (Include _) => accum | (Automatic _) => accum | (Connections _) => accum
    | (Library groups) => accum @ (map Group.findGroup groups)
    | (Link _) => accum)

fun getIncludeGroups (desc :groupDescription, accum :groupInfo list)
                  :groupInfo list =
  (case desc of
      (Library _) => accum | (Automatic _) => accum | (Connections _) => accum
    | (Include groups) => accum @ (map Group.findGroup groups)
    | (Link _) => accum)

fun rearrange (description :groupDescription list)
   :string list * string list * string list * groupInfo list * groupInfo list =
  let val revDescription = List.rev description
      val autoFiles = fold getAutoFileList revDescription []
      val connFiles = List.rev (fold getConnFileList revDescription [])
      val linkFiles = List.rev (fold getLinkFileList revDescription [])
      val libGroups = fold getLibraryGroups revDescription []
      val includeGroups = fold getIncludeGroups revDescription []
  in
    (autoFiles, connFiles, linkFiles, libGroups, includeGroups)
  end

end
