
structure StringObject: Object =

(* ASCII STRINGS

   Created by:  Dave Berry, LFCS, University of Edinburgh
                db@lfcs.ed.ac.uk
   Date:        12 Feb 1990

   Maintenance: Author

   DESCRIPTION

   Object definition for the built-in type "string".

*)

struct

(* TYPES *)

  type T = string


(* CONVERTORS *)

  open StringParse


(* OBSERVERS *)

  val fixedWidth = false

  (* Relational operators use Ascii ordering. *)
  local
    fun ltCase x y = ord x < ord y
    fun gtCase x y = ord x > ord y
	  
    fun compare p q listFn x y = 
	if p x y then true
	else if q x y then false
	else listFn (compare p q listFn) (explode x) (explode y)
  in
    fun lt _  "" = false
    |   lt "" _  = true
    |   lt x  y  = compare ltCase gtCase List'.lt x y

    fun le "" _  = true
    |   le _  "" = false
    |   le x  y  = compare ltCase gtCase List'.le x y

    fun gt "" _  = false
    |   gt _  "" = true
    |   gt x  y  = compare gtCase ltCase List'.gt x y

    fun ge "" _  = true
    |   ge _  "" = false
    |   ge x  y  = compare gtCase ltCase List'.ge x y
  end

  fun eq x y = (x = y)

  fun ne x y = (x <> y)
end
