signature Const =
sig

(* TAGGED VALUES

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	12 Dec 1989

   Maintenance:	Author


   DESCRIPTION

   The 'a Const type is a pair of a value and a unique tag.  The tests for
   equality compare the tags of their arguments.


   NOTES

   If 'a doesn't admit equality, then neither does 'a Const.  However,
   the functions eq and ne will still work.

   Ideally we would like the constructor Const to be visible, so that
   we could use it like ref.  We can't do that because it would show
   the internal representation.
*)

  val version: real
   (* version = 0.1 *)


(* TYPES *)

  type 'a Const


(* CREATORS *)

  val Create: 'a -> 'a Const


(* OBSERVERS *)

  val eq: 'a Const -> 'a Const -> bool

  val ne: 'a Const -> 'a Const -> bool


(* SELECTORS *)

  val !! : 'a Const -> 'a

end

