
signature Int =
sig

(* INTEGERS

   Created by:	Dave Berry, LFCS, University of Edinburgh
		db@lfcs.ed.ac.uk
   Date:	22 Sep 1989

   Maintenance:	Author


   DESCRIPTION

   Standard functions on the built-in type "int".


   NOTES

   The arithmetic exceptions are defined to raise Overflow for all
   overflow operations and Div for attempts to divide by zero.

   Possibly there should be functions dv, md and dvMd (with exceptions Dv
   and Md) that select the fastest of rem, mod, etc. for positive numbers.

   Possibly the function -- should raise an exception if start > finish + 1.

   Possibly there should be functions to read and write integers in binary
   as well as ascii.  Their specification would have say something about
   portability.

   Possibly there should be functions to read and write integers (to/from
   ascii) in different bases.
*)

  val version: real
   (* version = 0.1 *)


(* PERVASIVES *)

  exception Overflow
  and Div

  val + : int * int -> int
  val - : int * int -> int
  val * : int * int -> int
  val div: int * int -> int
  val mod: int * int -> int
  val ~ : int -> int
  val abs: int -> int
  val real: int -> real


(* SYSTEM *)

  val minInt: int Option
   (* minInt; the smallest integer that can be stored on the system, or
      None if the system supports arbitrary length integers. *)

  val maxInt: int Option
   (* maxInt; the largest integer that can be stored on the system, or
      None if the system supports arbitrary length integers. *)


(* OBJECT *)

  structure Object: Object
    sharing type Object.T = int

  type T
    sharing type T = int

  val parse': string list ->
              (int * string list, int Option * string list) Result

  val parse:  string -> (int, int Option) Result

  val read: InStream -> (int, int Option) Result

  val string: int -> string

  val fixedWidth: bool

  val eq: int -> int -> bool

  val ne: int -> int -> bool

  val lt: int -> int -> bool

  val le: int -> int -> bool

  val gt: int -> int -> bool

  val ge: int -> int -> bool


(* MANIPULATORS *)

  (* infix 7 divMod *)
  val divMod: int * int -> int * int
   (* x divMod y = (x div y, x mod y). *)

  (* infix 7 quot rem quotRem *)

  val quot: int * int -> int
   (* x quot y; like x div y but rounding toward zero. *)

  val rem: int * int -> int
   (* x rem y; like x mod y but rounding toward zero. *)

  val quotRem: int * int -> int * int
   (* x quotRem y = (x quot y, x rem y). *)

  val max: int -> int -> int
   (* max x y; returns the greater of x and y.  *)

  val min: int -> int -> int
   (* min x y; returns the lesser of x and y.  *)

  val maxMin: int -> int -> int * int
   (* maxMin x y = (max (x, y), min (x, y)) .  *)

  (* infix 5 -- *)
  val -- : int * int -> int list
   (* x -- y; returns the list of integers between x and y inclusive.
      Returns nil if x > y.  *)

  (* infix 8 ** *)
  exception **! of int * int
  val ** : int * int -> int
   (* x ** y; x raised to the power y. *)

end
