(*  Title: 	HOL/ex/prop
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1988  University of Cambridge

Classical Higher-order Logic: examples with propositional connectives

All these examples are really first-order.
They permit comparison with the first-order systems NJ and LK.

This file can be loaded to test the HOL system.


Single-step commands:

by (Pc.onestep_tac 1);
by (Pc.step_tac asms 1);
by (Pc.fast_tac asms 1);
by (biresolve_tac safe_brls 1);
by (biresolve_tac unsafe_brls 1);
by (assume_tac 1);
*)



val asms =
goal HOL_Rule.thy
    "(P --> Q) & P --> Q";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "P --> P & P";
by (Pc.fast_tac asms 1);
result();


writeln"commutative laws of & and | ";
val asms =
goal HOL_Rule.thy
    "P & Q  -->  Q & P";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "P | Q  -->  Q | P";
by (Pc.fast_tac asms 1);
result();


writeln"associative laws of & and | ";
val asms =
goal HOL_Rule.thy
    "(P & Q) & R  -->  P & (Q & R)";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(P | Q) | R  -->  P | (Q | R)";
by (Pc.fast_tac asms 1);
result();



writeln"distributive laws of & and | ";
goal HOL_Rule.thy
    "(P & Q) | R  --> (P | R) & (Q | R)";
by (Pc.fast_tac [] 1);
result();

val asms =
goal HOL_Rule.thy
    "(P | R) & (Q | R)  --> (P & Q) | R";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(P | Q) & R  --> (P & R) | (Q & R)";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(P & R) | (Q & R)  --> (P | Q) & R";
by (Pc.fast_tac asms 1);
result();


writeln"Laws involving implication";

val asms =
goal HOL_Rule.thy
    "(P-->Q) | (P-->R)  <->  (P --> Q | R)";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(P-->R) & (Q-->R) <-> (P|Q --> R)";
by (Pc.fast_tac asms 1);
result();


val asms =
goal HOL_Rule.thy
    "(P & Q --> R) <-> (P--> (Q-->R))";
by (Pc.fast_tac asms 1);
result();


val asms =
goal HOL_Rule.thy
    "((P-->R)-->R) --> ((Q-->R)-->R) --> (P&Q-->R) --> R";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(~(P-->R)) --> (~(Q-->R)) --> ~(P&Q-->R)";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy
    "(P --> Q & R) <-> (P-->Q)  &  (P-->R)";
by (Pc.fast_tac asms 1);
result();


writeln"Propositions-as-types";

(*The combinator K*)
val asms =
goal HOL_Rule.thy
    "P --> (Q --> P)";
by (Pc.fast_tac asms 1);
result();

(*The combinator S*)
val asms =
goal HOL_Rule.thy
    "(P-->Q-->R)  --> (P-->Q) --> (P-->R)";
by (Pc.fast_tac asms 1);
result();


val asms =
goal HOL_Rule.thy
    "(P-->Q)  -->  (~Q --> ~P)";
by (Pc.fast_tac asms 1);
result();


(*If and only if*)

val asms =
goal HOL_Rule.thy
    "(P<->Q) <-> (Q<->P)";
by (Pc.fast_tac asms 1);
result();

val asms =
goal HOL_Rule.thy "~ (P <-> ~P)";
by (Pc.fast_tac asms 1);
result();


(*Sample problems from 
  False. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.
  Errata, JAR 4 (1988), 236-236.
*)

writeln"Pelletier's examples";
(*1*)
val asms =
goal HOL_Rule.thy
    "(P-->Q)  <->  (~Q --> ~P)";
by (Pc.fast_tac asms 1);
result();

(*2*)
val asms =
goal HOL_Rule.thy "~ ~ P  <->  P";
by (Pc.fast_tac asms 1);
result();

(*3*)
val asms =
goal HOL_Rule.thy
    "~(P-->Q) --> (Q-->P)";
by (Pc.fast_tac asms 1);
result();

(*4*)
val asms =
goal HOL_Rule.thy
    "(~P-->Q)  <->  (~Q --> P)";
by (Pc.fast_tac asms 1);
result();

(*5*)
val asms =
goal HOL_Rule.thy
    "((P|Q)-->(P|R)) --> (P|(Q-->R))";
by (Pc.fast_tac asms 1);
result();

(*6*)
val asms =
goal HOL_Rule.thy "P | ~ P";
by (Pc.fast_tac asms 1);
result();

(*7*)
val asms =
goal HOL_Rule.thy "P | ~ ~ ~ P";
by (Pc.fast_tac asms 1);
result();

(*8.  Peirce's law*)
val asms =
goal HOL_Rule.thy
    "((P-->Q) --> P)  -->  P";
by (Pc.fast_tac asms 1);
result();

(*9*)
val asms =
goal HOL_Rule.thy
    "((P|Q) & (~P|Q) & (P| ~Q)) --> ~ (~P | ~Q)";
by (Pc.fast_tac asms 1);
result();

(*10*)
val asms =
goal HOL_Rule.thy
    "(Q-->R) & (R-->P&Q) & (P-->Q|R) --> (P<->Q)";
by (Pc.fast_tac asms 1);
result();

(*11.  Proved in each direction (incorrectly, says Pelletier!!)  *)
val asms =
goal HOL_Rule.thy "P<->P";
by (Pc.fast_tac asms 1);
result();

(*12.  "Dijkstra's law"*)
val asms =
goal HOL_Rule.thy
    "((P <-> Q) <-> R)  -->  (P <-> (Q <-> R))";
by (Pc.fast_tac asms 1);
result();

(*13.  Distributive law*)
val asms =
goal HOL_Rule.thy
    "P | (Q & R)  <-> (P | Q) & (P | R)";
by (Pc.fast_tac asms 1);
result();

(*14*)
val asms =
goal HOL_Rule.thy
    "(P <-> Q) <-> ((Q | ~P) & (~Q|P))";
by (Pc.fast_tac asms 1);
result();

(*15*)
val asms =
goal HOL_Rule.thy
    "(P --> Q) <-> (~P | Q)";
by (Pc.fast_tac asms 1);
result();

(*16*)
val asms =
goal HOL_Rule.thy
    "(P-->Q) | (Q-->P)";
by (Pc.fast_tac asms 1);
result();

(*17*)
val asms =
goal HOL_Rule.thy
    "((P & (Q-->R))-->S)  <->  ((~P | Q | S) & (~P | ~R | S))";
by (Pc.fast_tac asms 1);
result();



writeln"Reached end of examples.";

(*15 Aug 88: loaded this file in 140 secs*)
(*21 Aug 88: loaded this file in 109 secs*)
(*2 September 88: loaded this file in 99 secs*)
(*10 September 88: loaded this file in 61 secs*)
