(*  Title: 	LK/ex/hard-quant
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Hard examples with quantifiers.  Can be read to test the LK system.
From  F. J. Pelletier, 
  Seventy-Five Problems for Testing Automatic Theorem Provers,
  J. Automated Reasoning 2 (1986), 191-216.
  Errata, JAR 4 (1988), 236-236.

by (step_tac [triv_pack, LK_pack] 1);
*)

writeln"LK/ex/hard-quant: Hard examples with quantifiers";


writeln"Problem 18.  REQUIRES EXPLICIT STEP BECAUSE OF THINNING";
goal LK_Rule.thy "|- EX y. ALL x. P(y)-->P(x)";
by (resolve_tac [exists_right] 1);
by (pc_tac 1);
result(); 


writeln"Problem 19.  REQUIRES EXPLICIT STEP BECAUSE OF THINNING";
goal LK_Rule.thy
   "|- EX x. ALL y z. (P(y)-->Q(z)) --> (P(x)-->Q(x))";
by (resolve_tac [exists_right] 1);
by (pc_tac 1);  (*7 secs*)
result();


writeln"Problem 20";
goal LK_Rule.thy
   "|- (ALL x y. EX z. ALL w. (P(x)&Q(y)-->R(z)&S(w))) \    
\     -->  (EX x y. P(x) & Q(y)) --> (EX z. R(z))";
by (pc_tac 1);  (*3 secs*)
result();


writeln"Problem 21.  REQUIRES EXPLICIT STEPS BECAUSE OF THINNING ";
goal LK_Rule.thy
   "EX x. P-->Q(x), EX x. Q(x)-->P |- EX x. P<->Q(x)";
by (resolve_tac [exists_left] 1);
by (resolve_tac [exists_left] 1);
by (resolve_tac [exists_right] 1);
by (pc_tac 1);  (*4 secs*)
result();


writeln"Problem 22";
goal LK_Rule.thy
   "|- (ALL x. P <-> Q(x))  -->  (P <-> (ALL x. Q(x)))";
by (pc_tac 1);  (*1 secs*)
result();


writeln"Problem 23";
goal LK_Rule.thy "|- (ALL x. P | Q(x))  <->  (P | (ALL x. Q(x)))";
by (pc_tac 1);  (*1 sec*)
result();


writeln"Problem 24";
goal LK_Rule.thy
   "~ (EX x. S(x)&Q(x)),  \
\   ALL x. P(x) --> Q(x)|R(x),  \
\   (~ (EX x.P(x))) --> (EX x.Q(x)), \
\   ALL x. Q(x)|R(x) --> S(x) \
\   |- EX x. P(x)&R(x)";
by (pc_tac 1);  (*19 secs*)
result();


writeln"Problem 25";
goal LK_Rule.thy
   "EX x. P(x),  \
\   ALL x. L(x) --> ~ (M(x) & R(x)), \
\   ALL x. P(x) --> (M(x) & L(x)), \
\   (ALL x. P(x)-->Q(x)) | (EX x. P(x)&R(x))    |- EX x. Q(x)&P(x)";
by (pc_tac 1);  (*12 secs*)
result();


writeln"Problem 27";
goal LK_Rule.thy
   "EX x. P(x) & ~Q(x),  \
\   ALL x. P(x) --> R(x), \
\   ALL x. M(x) & L(x) --> P(x), \
\   (EX x. R(x) & ~ Q(x)) --> (ALL x. L(x) --> ~ R(x)) \
\   |- ALL x. M(x) --> ~L(x)";
by (pc_tac 1);  (*11 secs*)
result();


writeln"Problem 28.  AMENDED";
goal LK_Rule.thy
   "ALL x. P(x) --> (ALL x. Q(x)),  \
\   (ALL x. Q(x)|R(x)) --> (EX x. Q(x)&S(x)), \
\   (EX x.S(x)) --> (ALL x. L(x) --> M(x)) \
\   |- ALL x. P(x) & L(x) --> M(x)";
by (pc_tac 1);  (*9 sec*)
result();


writeln"Problem 29.  Essentially the same as Principia Mathematica *11.71";
goal LK_Rule.thy
   "(EX x. P(x)) & (EX x. Q(x))  \
\   |- (ALL x. P(x)-->R(x)) & (ALL x. Q(x)-->S(x))  \
\     <->  (ALL x y. P(x) & Q(y) --> R(x) & S(y))";
by (pc_tac 1);  (*11 secs*)
result();


writeln"Problem 30";
goal LK_Rule.thy
   "ALL x. P(x) | Q(x) --> ~ R(x),  \
\   ALL x. (Q(x) --> ~ S(x)) --> P(x) & R(x)   |- ALL x. S(x)";
by (pc_tac 1);   (*3 secs*)
result();


writeln"Problem 31";
goal LK_Rule.thy
   "~ (EX x.P(x) & (Q(x) | R(x))), \
\   EX x. L(x) & P(x),  \
\   ALL x. ~ R(x) --> M(x) \
\   |- EX x. L(x) & M(x)";
by (pc_tac 1); (*4 secs*)
result();


writeln"Problem 32";
goal LK_Rule.thy
   "ALL x. P(x) & (Q(x)|R(x))-->S(x),  \
\   ALL x. S(x) & R(x) --> L(x),  \
\   ALL x. M(x) --> R(x)           |- ALL x. P(x) & M(x) --> L(x)";
by (pc_tac 1); (*7 secs*)
result();


(*Times for loading file to this point:
  est.	1200 secs in April 88	
	367 secs on 3/May/88	with suppression of flexflex
	104 secs on 3/May/88	with filseq_resolve_tac
*)


writeln"Problem 33";
goal LK_Rule.thy
   "|- (ALL x. P(a) & (P(x)-->P(b))-->P(c))  <->   \
\      (ALL x. (~P(a) | P(x) | P(c)) & (~P(a) | ~P(b) | P(c)))";
by (pc_tac 1); (*6 secs*)
result();


writeln"Problem 35.  REQUIRES EXPLICIT STEP BECAUSE OF THINNING";
goal LK_Rule.thy   "|- EX x y. P (x,y) -->  (ALL x y.P(x,y))";
by (resolve_tac [exists_right] 1);
by (pc_tac 1); (*1 secs*)
result();


writeln"Problem 36.  NOT PROVED";
goal LK_Rule.thy
 "ALL x. EX y. F(x,y),    ALL x. EX y. G(x,y), \
\ ALL x y. F(x,y) | G(x,y) --> (ALL z. F(y,z) | G(y,z) --> H(x,z))  \
\ |- ALL x. EX y. H(x,y)";


writeln"Problem 37";
goal LK_Rule.thy
 "ALL z. EX w. ALL x. EX y. (P(x,z)-->P(y,w)) &  \
\              P(y,z) & (P(y,w)--> (EX u.Q(u,w))),  \
\ ALL x z. ~P(x,z) --> (EX y. Q(y,z)),  \
\ (EX x y. Q(x,y)) --> (ALL x. R(x,x))  \
\ |- ALL x. EX y. R(x,y)";
by (pc_tac 1); (*58 secs*)
result();


writeln"Problem 39";
goal LK_Rule.thy "|- ~ (EX x. ALL y. F(x,y) <-> ~F(y,y))";
by (pc_tac 1); (*1 secs*)
result();


writeln"Problem 40.  AMENDED";
goal LK_Rule.thy
 "|- (EX y. ALL x. F(y,x) <-> ~F(x,x))  -->    \
\    ~ (ALL x. EX y. ALL z. F(z,y) <-> ~ F(z,x))";
by (pc_tac 1); (*1 secs*)
result();


writeln"Reached end of file.";

(*21 August 88: loaded in 182 secs*)
