(*  Title: 	LK/ex/quant
    Author: 	Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1989  University of Cambridge

Classical FOL: examples with quantifiers.  Can be read to test the LK system.

by (step_tac [triv_pack, LK_pack] 1);
*)


writeln"LK/ex/quant: Examples with quantifiers";

goal LK_Rule.thy "|- (ALL x. P)  <->  P";
by (pc_tac 1);
result(); 

goal LK_Rule.thy "|- (ALL x y.P(x,y))  <->  (ALL y x.P(x,y))";
by (pc_tac 1);
result(); 

goal LK_Rule.thy "ALL u.P(u), ALL v.Q(v) |- ALL u v. P(u) & Q(v)";
by (pc_tac 1);
result(); 

writeln"Permutation of EXISTS.";
goal LK_Rule.thy
  "|- (EX x y.P(x,y)) <-> (EX y x.P(x,y))";
by (pc_tac 1);
result(); 

goal LK_Rule.thy "|- (ALL x. P(x) & Q(x)) <-> (ALL x.P(x)) & (ALL x.Q(x))";
by (pc_tac 1);
result(); 


(*Converse is invalid*)
goal LK_Rule.thy "|- (ALL x. P(x)) | (ALL x. Q(x)) --> (ALL x. P(x)|Q(x))";
by (pc_tac 1);
result(); 


writeln"Pushing ALL into an implication.";
goal LK_Rule.thy "|- (ALL x. P --> Q(x))  <->  (P --> (ALL x. Q(x)))";
by (pc_tac 1);
result(); 


goal LK_Rule.thy "|- (ALL x.P(x)-->Q)  <->  ((EX x.P(x)) --> Q)";
by (pc_tac 1);
result(); 


goal LK_Rule.thy "|- (EX x. P)  <->  P";
by (pc_tac 1);
result(); 


writeln"Distribution of EX over disjunction.";
goal LK_Rule.thy "|- (EX x. P(x) | Q(x)) <-> (EX x. P(x))  |  (EX x. Q(x))";
by (pc_tac 1);
result(); 
(*5 secs*)

(*Converse is invalid*)
goal LK_Rule.thy "|- (EX x. P(x) & Q(x))  -->  (EX x. P(x))  &  (EX x. Q(x))";
by (pc_tac 1);
result(); 


writeln"Harder examples: classical theorems.";

goal LK_Rule.thy "|- (EX x. P-->Q(x))  <->  (P --> (EX x.Q(x)))";
by (pc_tac 1);
result(); 
(*3 secs*)


goal LK_Rule.thy "|- (EX x.P(x)-->Q)  <->  (ALL x.P(x)) --> Q";
by (pc_tac 1);
result(); 
(*5 secs*)


goal LK_Rule.thy "|- (ALL x.P(x)) | Q  <->  (ALL x. P(x) | Q)";
by (pc_tac 1);
result(); 


writeln"Basic test of quantifier reasoning";
goal LK_Rule.thy
   "|- (EX y. ALL x. Q(x,y)) --> (ALL x. EX y. Q(x,y))";
by (pc_tac 1);
result();  


goal LK_Rule.thy "|- (ALL x. Q(x))  -->  (EX x. Q(x))";
by (pc_tac 1);
result();  


writeln"The following are invalid!";

(*INVALID*)
goal LK_Rule.thy "|- (ALL x. EX y. Q(x,y))  -->  (EX y. ALL x. Q(x,y))";
by (pc_tac 1);
(*Check that subgoals remain: proof failed.*)
getgoal 1;  

(*INVALID*)
goal LK_Rule.thy "|- (EX x. Q(x))  -->  (ALL x. Q(x))";
by (pc_tac 1);
getgoal 1; 

goal LK_Rule.thy
    "|- (ALL x. P(x)-->Q(x)) & (EX x.P(x)) --> (EX x.Q(x))";
by (pc_tac 1);
result();  



(*An example of why exists_right should be delayed as long as possible*)
goal LK_Rule.thy "|- (P--> (EX x.Q(x))) & P--> (EX x.Q(x))";
by (pc_tac 1);
result();  


writeln"Solving for a Var";
goal LK_Rule.thy "|- (ALL x. P(x)-->Q(f(x))) & (ALL x. Q(x)-->R(g(x))) & P(d) \
\	--> R(?a$$term)";
by (pc_tac 1);
uresult();  (*Cannot use 'result' since ?a will be instantiated*)


(*Not provable by pc_tac: needs multiple instantiation of ALL
  search is rather stupid*)
goal LK_Rule.thy 
  "|- (ALL x. P(x)-->P(f(x)))  &  P(d)-->P(f(f(f(d))))";
by (BREADTH_FIRST (has_prems 0)
 	(reresolve_tac [basic, imp_right, imp_left, conj_left] 1 
         ORELSE resolve_tac [all_left] 1));
result();


(*Not provable by pc_tac: needs double instantiation of EXISTS*)
goal LK_Rule.thy "|- EX x. P(x) --> P(a) & P(b)";
by (resolve_tac [exists_right] 1);
by (pc_tac 1);
result();


goal LK_Rule.thy "|- EX x. P(x) --> (ALL x. P(x))";
by (resolve_tac [exists_right] 1);
by (pc_tac 1);
result();


writeln"More fallacies";
goal LK_Rule.thy "|- P(?a) --> (ALL x.P(x))";
by (pc_tac 1);
(*Check that subgoals remain: proof failed.*)
getgoal 1;  

goal LK_Rule.thy "|- (P(?a) --> (ALL x.Q(x))) --> (ALL x. P(x) --> Q(x))";
by (pc_tac 1);
getgoal 1;  


writeln"Principia Mathematica *11.53";
goal LK_Rule.thy 
    "|- (ALL x y. P(x) --> Q(y)) <-> ((EX x. P(x)) --> (ALL y. Q(y)))";
by (pc_tac 1);
result();
(*4 secs*)


writeln"Principia Mathematica *11.55";
goal LK_Rule.thy "|- (EX x y. P(x) & Q(x,y)) <-> (EX x. P(x) & (EX y.Q(x,y)))";
by (pc_tac 1);
result();
(*5 secs*)

writeln"Principia Mathematica *11.61";
goal LK_Rule.thy
   "|- (EX y. ALL x. P(x) --> Q(x,y)) --> (ALL x. P(x) --> (EX y. Q(x,y)))";
by (pc_tac 1);
result();

writeln"Reached end of file.";

(*21 August 88: loaded in 45.7 secs*)
