# SPIM S20 MIPS simulator.
# A torture test for the SPIM simulator (running in bare_machine mode)
# Copyright (C) 1990 James Larus, larus@cs.wisc.edu.
#
# SPIM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 1, or (at your option) any
# later version.
#
# SPIM is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU CC; see the file COPYING.  If not, write to James R.
# Larus, Computer Sciences Department, University of Wisconsin--Madison,
# 1210 West Dayton Street, Madison, WI 53706, USA or to the Free
# Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

# $Header: /var/home/larus/SPIM/RCS/tt.bare.s,v 1.8 90/12/11 15:07:23 larus Exp Locker: larus $

# Define the exception handling code.  This must go first!
# Duplicate of standard trap handler.

	.data
	.globl __m1_
__m1_:	.asciiz "  Exception "
	.globl __m2_
__m2_:	.asciiz " occurred\n"
	.ktext
	.space 0x80	# Put trap handler at 0x8000080
	mfc0 $26 $13	# Cause
	mfc0 $27 $14	# EPC
	addiu $v0, $0, 4	# syscall 4 (print_str)
#	la $a0 __m1_
	lui $a0, 0x1000
	syscall
	addiu $v0, $0, 1	# syscall 1 (print_int)
	addu $a0 $0 $26
	syscall
	addiu $v0, $0, 4	# syscall 4 (print_str)
#	la $a0 __m2_
	lui $a0, 0x1000
	ori $a0, $a0, 0xd
	syscall
	mtc0 $0, $13		# Clear Cause register
	rfe			# Return from exception handler
	addiu $27 $27 4		# Return to next instruction
	jr $27

# Standard startup code.  Invoke the routine main with no arguments.

	.text
	.globl __start
__start: jal main
	addu $0, $0, $0		# Nop
	addiu $v0, $0, 10
	syscall			# syscall 10 (exit)


	.globl main
main:
	addu $20, $0, $31	# Save return PC

# Test delayed branches:

	addiu $2, $0, 0
	beq $0 $0 l1
	addiu $2, $0, 1		# Delayed instruction
l1:	addiu $3, $0, 1
	bne $2 $3 fail
	addu $0, $0, $0		# Nop

# Test delayed loads:

	.data
	.globl d
d:	.word 101
	.text
	addiu $3, $0, 0
	lui $4 0x1000
	lw $3 0x18($4)		# address of d
	addiu $2, $3, 0		# Delayed instruction
	bne $2 $0 fail
	addu $0, $0, $0		# Nop

# Done !!!
	.data
	.globl sm
sm:	.asciiz "\nPassed all tests\n"
	.text
	addiu $v0, $0, 4	# syscall 4 (print_str)
#	la $a0 sm
	lui $a0, 0x1000
	ori $a0, $a0, 0x01c
	syscall
	addu $31, $0 $20	# Return PC
	jr $31		# Return from main


	.data
	.globl fm
fm:	.asciiz "Failed test\n"
	.text
fail:	addiu $v0, $0, 4	# syscall 4 (print_str)
#	la $a0 fm
	lui $a0, 0x1000
	ori $a0, $a0, 0x2f
	syscall
	addiu $v0, $0, 10	# syscall 10 (exit)
	syscall
