(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Nov  3 11:55:47 1989 by muller         *)
(*      modified on Thu Nov  2 18:18:07 1989 by gnelson        *)
(*      modified on Thu Nov  2 18:18:07 1989 by manasse        *)

INTERFACE AutoFlushWr;

(* Writers that are automatically flushed; useful for writing to
   terminals. *)

IMPORT Wr;

TYPE T <: Wr.T;

PROCEDURE New(ch: Wr.T; p := -1): T;
(* After wr := New(ch), everything written to wr will be forwarded 
   to ch (that is, target(wr) = target(ch)).  Furthermore, wr will 
   be flushed automatically by a background thread every p milliseconds 
   (approximately).  If p is -1, it defaults to a value that is 
   reasonable for writing to terminals.  The child ch must be unlocked 
   when New is called. After ch has been passed to New, you must not 
   operate on ch (except implicitly through wr).  Flushing wr flushes 
   ch; closing wr closes ch. *)

END AutoFlushWr.

