(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by J.Stolfi on Nov 1990                             *)
(* Last modified on Wed Feb 12 12:37:53 PST 1992 by muller     *)
(*      modified on Fri Nov  1 23:35:00 PST 1991 by stolfi     *)

INTERFACE SxPrivate;

(*
  Private definitions for Sx.def

  This friends-only interface defines the representations of the 
  opaque types in Sx, SxTypes, and related interfaces.    This allows 
  sx implementors and friends to access the representations of the 
  opaque types. 
  *)

(**********************************************************)
(*                                                        *)
(* PREBOXED VALUES                                        *)
(*                                                        *)
(**********************************************************)

CONST
  MaxPreboxedInteger =  +1023;
  MinPreboxedInteger =  -1024;

VAR (*CONST*)
  PreboxedInteger: ARRAY [MinPreboxedInteger..MaxPreboxedInteger] OF REF INTEGER;
  LastInteger: REF INTEGER;
  FirstInteger: REF INTEGER;

  PreboxedChar: ARRAY CHAR OF REF CHAR;

  PreboxedBoolean: ARRAY BOOLEAN OF REF BOOLEAN;
  Negation: ARRAY BOOLEAN OF REF BOOLEAN;

  RealZero:     REF REAL;
  RealOne:      REF REAL;
  RealMinusOne: REF REAL;
  RealTwo:      REF REAL;
  RealHalf:     REF REAL;

  LongRealZero:     REF LONGREAL;
  LongRealOne:      REF LONGREAL;
  LongRealMinusOne: REF LONGREAL;
  LongRealTwo:      REF LONGREAL;
  LongRealHalf:     REF LONGREAL;

  EmptyVector: REF ARRAY OF REFANY;

(**********************************************************)
(* INITIALIZATION                                         *)
(**********************************************************)

PROCEDURE Init();
(*
  Must be called before any use of other procedures or variables in
  the Sx interface.  Assumes that SxSyntax is already fully initailized. *)

END SxPrivate.
