(*

	Modules.i3
	----------

Verwendet ProgFileIO.m3, um Modula-3 Programme zu lesen. Dabei soll herausge-
funden werden, welche Module von einem Modul aus importiert werden.

Modules baut eine Liste von Moduln auf - T.getModules(). Mit T.beginScann() und T.next kann diese Liste durchlaufen werden. Nach jedem Aufruf von T.next() liefern die Aufrufe T.uptodate() und T.publicInterface() Informationen ber diesen Modul. T.uptodate() liefert TRUE
*****************************************************************************)



INTERFACE Modules;

IMPORT	Rd, System, ProgFileIO;


EXCEPTION NotFound(TEXT);


TYPE	T <: Public;

	Public = OBJECT
		(* Defaults *)	(* weitere Dirs. knnen mit einem ":"*)
				(* getrennt angehngt werden.        *)
		publicPath:=	"/software/m3/include";
		sourcePath:=	".";
		searchMode:=	FALSE;

	    METHODS
		getModules (RootDateiname: TEXT)	(* Module suchen *)
		    RAISES {NotFound, Rd.Failure, Rd.EndOfFile,
			    ProgFileIO.SyntaxError, System.Error};
		
		beginScann ();
		next (): TEXT;	(* Retourniert NIL, wenn nichts mehr da ist. *)

		uptodate(): BOOLEAN;
		publicInterface(): BOOLEAN;
	    END; (*OBJECT*)


(* Fr Dateinamen der Form:  Module.m3 ****************)

PROCEDURE Basename(in: TEXT): TEXT;	(* erster Teil (vor dem Punkt): *)
PROCEDURE Extname(in: TEXT): TEXT;	(* zweiter Teil (nach dem Punkt): *)

VAR verbose:= FALSE;	(* gibt Debugging-Informationen aus, wenn TRUE *)
END Modules.
