MODULE MyFile;

(* Created at April 1994 by Johann Jerney. *)

IMPORT Text, SIO, SF;

PROCEDURE GetLine(rd:SF.Reader):TEXT=

(* Reads a line from input. *)

VAR line:TEXT:="";
    ch:CHAR;

BEGIN
  ch:=SIO.GetChar(rd);
  WHILE ch#'\r' AND ch#'\n' AND NOT SIO.End(rd) DO 
    line:=line&Text.FromChar(ch);
    ch:=SIO.GetChar(rd);
  END;
  IF NOT SIO.End(rd) AND ch#'\n' AND SIO.LookAhead(rd)='\n' THEN
    EVAL SIO.GetChar(rd);
  END;
  RETURN(line);
END GetLine;

BEGIN (* MyFile *)
END MyFile.
