(*

  ProgFileIO
  ----------

ProgFileIO.T ist ein Objekt und entspricht einem Textfile. Mit Init(UnixFilename) wird
ein Textfile geffnet. Das kann zeichen- oder wortweise gelesen werden. Ziel ist es, 
ein Modula-3 Programm Syntaxeinheit fr Syntaxeinheit zu lesen, deshalb sind Wrter 
alle Zeichenfolgen zwischen zwei Delimiters, die meisten Tokens (Operatoren, Zahlen, 
Folgen wie <, #, >= etc.) sowie Kommentare usw. Insbesondere sind String- bzw. 
Character-Literals ebenfalls Wrter.

Gelesene Wrter werden mit der Funktion T.tokenType() in verschiedene Kategorien 
eingeteilt. Die Funktion liefert den Typ TokenTypes zurck, und ist jeweils nach jedem 
Aufruf von T.getWord() definiert.

Da durch die Verwendung von T.getWord() Informationen ber das Aussehen der Datei 
verloren geht, liefern die Funktionen T.lineIndent() und T.currRow() die Einrckung der 
aktuell gelesenen Zeile des Textfiles und die aktuelle Spaltenposition (des Anfangs des 
letzten Wortes) als Characteranzahl zurck. Dabei werden TABS im Textfile gezhlt, als 
wren an ihrer Stelle Blanks gesetzt worden.

T ist so definiert, da es subtypisiert werden kann, um andere Quellsprachen
auer Modula-3 ebenfalls abarbeiten zu knnen. Dazu mssen die Tabellen fr die 
Keywords, Operators etc. berschrieben werden, und einige Methoden zum Lesen 
von Tokens neu implementiert werden (um z.B. unterschiedliche Syntaxen fr Zahlen 
lesen zu knnen). Dabei wird von T.getWord aufgerufen:
	T.getComment, wenn einer der Strings T.commentStart gelesen wurde;
	T.getPragma, wenn einer der Strings T.pragmaStart gelesen wurde;
	T.getNumber, wenn eine Ziffer gelesen wurde;
	T.getLiterals, wenn entweder " oder ' gelesen wurde; T.getLiterals mu
	  nur berschrieben werden, wenn das Quote-Zeichen anders als mit der
	  der Folge Backspace-Quote im String dargestellt wird.

Fest eingebaut sind folgende Details:

Alles, was mit einem Buchstaben anfngt, mu ein Identifier oder Keyword sein. Alles, 
was mit einer Ziffer anfngt, mu eine Zahl sein. Was mit T.charQuote anfngt, ist ein 
CharacterLiteral, was mit T.stringQuote anfngt ein TextLiteral.
******************************************************************************)


INTERFACE ProgFileIO;


IMPORT	Rd, Char;

EXCEPTION SyntaxError(TEXT);	
			(* wird bei schlechten Zahlen, fehlenden Kommentar- *)
			(* klammern oder unvollstndigen Strings aufgebracht*)
			(* Modula-3 Syntax wird {\em nicht} berprft!      *)

TYPE	TokenTypes = {Keyword, Operator, Pragma, Comment,
		      Identifier, CharacterLiteral, TextLiteral, Number};
	

TYPE	T <: Public;

	Public = OBJECT
		whiteSpaces	:= SET OF CHAR
		      {	Char.SP, Char.HT, Char.NL, Char.CR };
		newLine		:= Char.NL;
		tabStops	:= 8;

		identChars	:= SET OF CHAR
		      { 'a'..'z', 'A'..'Z', '_', '0'..'9' };
		charQuote	:= '\'';
		stringQuote	:= '"';

		keywords	:= ARRAY [0..100] OF TEXT
		      {	"ABS", "ADDRESS", "ADR", "ADRSIZE", "AND", "ANY",
			"ARRAY", "AS", "BEGIN", "BITS", "BITSIZE", "BOOLEAN",
			"BRANDED", "BY", "BYTESIZE", "CARDINAL", "CASE",
			"CEILING", "CHAR", "CONST", "DEC", "DISPOSE", "DIV",
			"DO", "ELSE", "ELSIF", "END", "EVAL", "EXCEPT",
			"EXCEPTION", "EXIT", "EXPORTS", "EXTENDED", "FALSE",
			"FINALLY", "FIRST", "FLOAT", "FLOOR", "FOR", "FROM",
			"IF", "IMPORT", "IN", "INC", "INTEGER", "INTERFACE",
			"ISTYPE", "LAST", "LOCK", "LONGREAL", "LOOP",
			"LOOPHOLE", "MAX", "METHODS", "MIN", "MOD", "MODULE",
			"MUTEX", "NARROW", "NEW", "NIL", "NOT", "NULL",
			"NUMBER", "OBJECT", "OF", "OR", "ORD", "OVERRIDE",
			"PROCEDURE", "RAISE", "RAISES", "READONLY", "REAL",
			"RECORD", "REF", "REFANY", "REPEAT", "RETURN",
			"REVEAL", "ROOT", "ROUND", "SET", "SUBARRAY", "TEXT",
			"THEN", "TO", "TRUE", "TRUNC", "TRY", "TYPE",
			"TYPECASE", "TYPECODE", "UNSAFE", "UNTIL", "UNTRACED",
			"VAL", "VALUE", "VAR", "WHILE", "WITH"};
		operators	:= ARRAY [0..26] OF TEXT
		       { "+", "-", "*", "/", ".", "^", ":=", "=", "#", "<",
			 "<=", ">=", ">", "&", "<:", "=>", ",", ";", "|", ":",
			 "..", "(", ")", "{", "}", "[", "]"};
		commentStart	:= ARRAY [0..0] OF TEXT
		       { "(*"};
		pragmaStart	:= ARRAY [0..0] OF TEXT
		       { "<*"};

	    METHODS
		getChar(): CHAR RAISES {Rd.Failure, Rd.EndOfFile};
		ungetChar();
				(* Setzen auch die row und line-Information *)

		getWord(): TEXT RAISES {Rd.Failure,Rd.EndOfFile,SyntaxError};
				(* nchstes Wort (Token) lesen   *)
				
		tokenType():	TokenTypes;	(* Typ des letzten Tokens   *)
		lineIndent():	INTEGER;	(* Einrckg. der akt. Zeile *)
		currRow():	INTEGER;	(* aktuelle Spalte          *)
		currLine():	INTEGER;	(* aktuelle Zeile           *)

		(* Standard-Textdateioperationen (nur fr lesen) werden als *)
		(* Default von anderen Modulen importiert (z.B. FileStream) *)
		open(FileName: TEXT) RAISES {Rd.Failure}; (*Textdatei ffnen*)
		close() RAISES {Rd.Failure};	(* Resourcen freigeben      *)
		eof(): BOOLEAN RAISES {Rd.Failure};(* TRUE wenn end-of-file.*)

		(* Folgende Methoden werden von getWord() aus aufgerufen. *)
		(* Subtypen von T fr andere Quellsprachen als MODULA-3   *)
		(* werden diese eventuell berschreiben mssen (z.B. fr  *)
		(* andere Escapes des Hochkommas bei Literals).           *)

		getNumber(): TEXT
			RAISES {Rd.Failure,Rd.EndOfFile,SyntaxError};	
				(* nchste Zahl, wird von getWord() *)
				(* aufgerufen.                      *)
		getLiteral (Quote: CHAR): TEXT
			RAISES {Rd.Failure,Rd.EndOfFile,SyntaxError};	
				(* bernimmt Quote in den Resultatstring und *)
				(* liest solange, bis Quote im Inputstream   *)
				(* wieder auftaucht. Das Auftauchen von      *)
				(* self.newLine im Inputstream fhrt zum     *)
				(* SyntaxError. Quote kann mit Backspaces    *)
				(* "escaped" werden: \'                      *)
	        getComment(startSequenz: TEXT): TEXT
			RAISES {SyntaxError, Rd.Failure};
	        getPragma(startSequenz: TEXT): TEXT
			RAISES {SyntaxError, Rd.Failure};
		
	    END; (*OBJECT*)


END ProgFileIO.	