MODULE trc;

(* Preprocesses tmpfile and creates targetfile.
   debug=TRUE: Every %%  will be substituted by two blanks.
   debug=FALSE: Every %% will be substituted by a commentsigns. *)

IMPORT Char, SIO, SF;

PROCEDURE pp(targetfile, tmpfile:TEXT)=

VAR source_ptr:SF.Reader;
    target_ptr:SF.Writer;
    in_trc:BOOLEAN:=FALSE;
    ch:CHAR;

BEGIN (* pp *)
  source_ptr:=SF.OpenRead(tmpfile);
  target_ptr:=SF.OpenWrite(targetfile,"",TRUE);
  ch:=SIO.GetChar(source_ptr);
  WHILE NOT SIO.End(source_ptr) DO
    IF NOT in_trc AND ch='(' THEN
      (* ffnende Klammer. *)
      ch:=SIO.GetChar(source_ptr);
      IF ch='*' THEN
        ch:=SIO.GetChar(source_ptr);
        IF ch='%' THEN
          ch:=SIO.GetChar(source_ptr);
          IF ch='%' THEN
            SIO.PutChar(' ',target_ptr);
            SIO.PutChar(' ',target_ptr); 
            SIO.PutChar(' ',target_ptr);
            SIO.PutChar(' ',target_ptr); 
            in_trc:=TRUE;
          ELSE
            SIO.PutChar('(',target_ptr);
            SIO.PutChar('*',target_ptr);
            SIO.PutChar('%',target_ptr);
            SIO.PutChar(ch,target_ptr);
          END; (* IF *)
        ELSE
          SIO.PutChar('(',target_ptr);
          SIO.PutChar('*',target_ptr);
          SIO.PutChar(ch,target_ptr);
        END; (* IF *)
      ELSE
        SIO.PutChar('(',target_ptr);
        SIO.PutChar(ch,target_ptr);
      END; (* IF *)
      ch:=SIO.GetChar(source_ptr);
    ELSIF in_trc AND ch='%' THEN
      (* Knnte schlieende Klammer sein. *)
      ch:=SIO.GetChar(source_ptr);
      IF ch='%' THEN
        ch:=SIO.GetChar(source_ptr);
        IF ch='*' THEN
          ch:=SIO.GetChar(source_ptr);
          IF ch=')' THEN
            SIO.PutChar(' ',target_ptr);
            SIO.PutChar(' ',target_ptr); 
            SIO.PutChar(' ',target_ptr);
            SIO.PutChar(' ',target_ptr); 
            in_trc:=FALSE;
          ELSE
            SIO.PutChar('%',target_ptr);
            SIO.PutChar('%',target_ptr);
            SIO.PutChar('*',target_ptr);
            SIO.PutChar(ch,target_ptr);
          END; (* IF *)
        ELSE
          SIO.PutChar('%',target_ptr);
          SIO.PutChar('%',target_ptr);
          SIO.PutChar(ch,target_ptr);
        END; (* IF *)
      ELSE
        SIO.PutChar('%',target_ptr);
        SIO.PutChar(ch,target_ptr);
      END; (* IF *)
      ch:=SIO.GetChar(source_ptr);
    ELSE
      (* Normales Zeichen. *)
      SIO.PutChar(ch,target_ptr);
      ch:=SIO.GetChar(source_ptr);
    END; (* IF *)
  END; (* WHILE *)
  SIO.PutChar(Char.NL,target_ptr);
  SF.CloseWrite(target_ptr);
  SF.CloseRead(source_ptr);
END pp;

BEGIN (* trc *)
END trc.
